% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_n.R
\name{top_n_tbl}
\alias{top_n_tbl}
\alias{top_n}
\alias{bottom_n_tbl}
\alias{bottom_n}
\alias{lump_top_n}
\alias{lump_bottom_n}
\title{Top N most/least frequent values}
\usage{
top_n_tbl(x, n = 5, na_rm = FALSE, with_ties = FALSE)

top_n(x, n = 5, na_rm = FALSE, with_ties = FALSE)

bottom_n_tbl(x, n = 5, na_rm = FALSE, with_ties = FALSE)

bottom_n(x, n = 5, na_rm = FALSE, with_ties = FALSE)

lump_top_n(
  x,
  n = 5,
  na_rm = FALSE,
  with_ties = FALSE,
  as_factor = TRUE,
  other_category = "Other"
)

lump_bottom_n(
  x,
  n = 5,
  na_rm = FALSE,
  with_ties = FALSE,
  as_factor = TRUE,
  other_category = "Other"
)
}
\arguments{
\item{x}{\link{vector}}

\item{n}{\link{integer} Number of categories to include.}

\item{na_rm}{\link{logical} Should \code{NA} values be removed? Default is \code{FALSE}.}

\item{with_ties}{\link{logical} Should ties be kept? Default is \code{FALSE}.}

\item{as_factor}{\link{logical} Should the result be a factor? Default is \code{TRUE}.}

\item{other_category}{\link{character} Name of the other category. Default is "Other".}
}
\value{
\code{top_n}/\code{bottom_n} return a vector the same class as \code{x}. \cr
\code{top_n_tbl}/\code{bottom_n_tbl} return a 2-col \code{data.frame}. \cr
\code{lump_top_n}/\code{lump_bottom_n} return a \code{factor} (or \code{character} vector).
}
\description{
Inspired by \code{forcats::fct_lump_n} and by the lack of a good alternative. \cr
These are very fast and memory efficient.
}
\details{
\code{top_n} returns a vector of the most frequent values, with an
added attribute of counts named "n". \cr
\code{top_n_tbl} returns a data frame of top n values and associated counts. \cr
\code{lump_top_n} returns a factor such that any values not in the top n values are
placed into a separate category "Other".
}
\examples{
library(dplyr)
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
### Top 3 hair colours
timeplyr::top_n(starwars$hair_color, n = 3)

starwars \%>\%
  count(hair_col = lump_top_n(hair_color, n = 3))

top_n_tbl(starwars$hair_color, n = 3)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
