% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.constparty}
\alias{tidy.constparty}
\title{Get the \link{rulelist} from a \link[partykit:party]{party} model}
\usage{
\method{tidy}{constparty}(x, ...)
}
\arguments{
\item{x}{\link[partykit:party]{partykit::party} model typically built using \link[partykit:ctree]{partykit::ctree}}

\item{...}{Other arguments (currently unused)}
}
\value{
A \link{rulelist} object
}
\description{
Each row corresponds to a rule
}
\details{
These types of \link[partykit:party]{party} models are supported:
\code{regression} (y is numeric), \code{classification} (y is factor)

For \link[partykit:party]{party} classification model:
\itemize{
\item Output columns are: \code{rule_nbr}, \code{LHS}, \code{RHS}, \code{support}, \code{confidence}, \code{lift}, \code{terminal_node_id}.
\item Rules are sorted in this order: \code{desc(confidence)}, \code{desc(lift)},
\code{desc(support)}.
}

For \link[partykit:party]{party} regression model:
\itemize{
\item Output columns are: \code{rule_nbr}, \code{LHS}, \code{RHS}, \code{support}, \code{IQR}, \code{RMSE}, \code{terminal_node_id}.
\item Rules are sorted in this order: \code{RMSE}, \code{desc(support)}.
}
}
\examples{
pen = palmerpenguins::penguins
model_class_party = partykit::ctree(species ~ ., data = pen)
tidy(model_class_party)
model_regr_party = partykit::ctree(bill_length_mm ~ ., data = pen)
tidy(model_regr_party)

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}
}
