% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rulelist.R
\name{predict.rulelist}
\alias{predict.rulelist}
\title{\code{predict} method for a \link{rulelist}}
\usage{
\method{predict}{rulelist}(object, new_data, multiple = FALSE, ...)
}
\arguments{
\item{object}{A \link{rulelist}}

\item{new_data}{(dataframe)}

\item{multiple}{(flag, default: FALSE) Whether to output all rule numbers
applicable for a row. If FALSE, the first satisfying rule is provided.}

\item{...}{unused}
}
\value{
A  dataframe. See \strong{Details}.
}
\description{
Predicts \code{rule_nbr} applicable (as per the order in rulelist)
for a \code{row_nbr} (per key) in new_data
}
\details{
If a \code{row_nbr} is covered more than one \code{rule_nbr} per 'keys', then
\code{rule_nbr} appearing earlier (as in row order of the \link{rulelist}) takes
precedence.
\subsection{Output Format}{
\itemize{
\item When multiple is \code{FALSE}(default), output is a dataframe with three
or more columns: \code{row_number} (int), columns corresponding to 'keys',
\code{rule_nbr} (int).
\item When multiple is \code{TRUE}, output is a dataframe with three
or more columns: \code{row_number} (int), columns corresponding to 'keys',
\code{rule_nbr} (list column of integers).
\item If a row number and 'keys' combination is not covered by any rule, then
\code{rule_nbr} column has missing value.
}
}
}
\examples{
model_c5 = C50::C5.0(species ~.,
                     data = palmerpenguins::penguins,
                     trials = 5,
                     rules = TRUE
                     )
tidy_c5 = tidy(model_c5)
tidy_c5

output_1 = predict(tidy_c5, palmerpenguins::penguins)
output_1 # different rules per 'keys' (`trial_nbr` here)

output_2 = predict(tidy_c5, palmerpenguins::penguins, multiple = TRUE)
output_2 # `rule_nbr` is a list-column of integer vectors

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}
}
