% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-indexes.R
\name{compute_indexes}
\alias{compute_indexes}
\alias{augment.idx_res}
\title{Calculate multiple indexes at once}
\usage{
compute_indexes(.data, ...)

\method{augment}{idx_res}(x, .id = ".id", ...)
}
\arguments{
\item{.data}{an \code{idx_tbl} object}

\item{...}{Unused, included for generic consistency only}

\item{x}{an \code{idx_res} object, calculated from \code{compute_indexes}}

\item{.id}{a character string, the name of the first column}
}
\value{
an \code{idx_res} object
}
\description{
Calculate multiple indexes at once
}
\examples{
library(dplyr)
library(lmomco)
library(generics)
res <- tenterfield |>
  mutate(month = lubridate::month(ym)) |>
  init(id = id, time = ym, group = month) |>
  compute_indexes(
    spi = idx_spi(),
    spei = idx_spei(.lat = lat, .tavg = tavg),
    edi = idx_edi()
 )
}
