% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clust.R
\name{hier_clust}
\alias{hier_clust}
\title{Hierarchical (Agglomerative) Clustering}
\usage{
hier_clust(
  mode = "partition",
  engine = "stats",
  num_clusters = NULL,
  cut_height = NULL,
  linkage_method = "complete"
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "partition".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"stats"}.}

\item{num_clusters}{Positive integer, number of clusters in model (optional).}

\item{cut_height}{Positive double, height at which to cut dendrogram to
obtain cluster assignments (only used if \code{num_clusters} is \code{NULL})}

\item{linkage_method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC).}
}
\value{
A \code{hier_clust} cluster specification.
}
\description{
\code{hier_clust()} defines a model that fits clusters based on a distance-based
dendrogram
}
\examples{
# Show all engines
modelenv::get_from_env("hier_clust")

hier_clust()
}
