% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals-make-wflw.R
\name{internal_make_wflw}
\alias{internal_make_wflw}
\title{Internals Safely Make Workflow from Model Spec tibble}
\usage{
internal_make_wflw(.model_tbl, .rec_obj)
}
\arguments{
\item{.model_tbl}{The model table that is generated from a function like
\code{fast_regression_parsnip_spec_tbl()}, must have a class of "tidyaml_mod_spec_tbl".}

\item{.rec_obj}{The recipe object that is going to be used to make the workflow
object.}
}
\value{
A list object of workflows.
}
\description{
Safely Make a workflow from a model spec tibble.
}
\details{
Create a model specification tibble that has a \code{\link[workflows:workflow]{workflows::workflow()}}
list column.
}
\examples{
library(recipes, quietly = TRUE)

mod_spec_tbl <- fast_regression_parsnip_spec_tbl(
  .parsnip_eng = c("lm","glm","gee"),
  .parsnip_fns = "linear_reg"
)

rec_obj <- recipe(mpg ~ ., data = mtcars)

internal_make_wflw(mod_spec_tbl, rec_obj)

}
\seealso{
Other Internals: 
\code{\link{internal_make_fitted_wflw}()},
\code{\link{internal_make_spec_tbl}()},
\code{\link{internal_make_wflw_gee_lin_reg}()},
\code{\link{internal_make_wflw_predictions}()},
\code{\link{internal_set_args_to_tune}()},
\code{\link{make_classification_base_tbl}()},
\code{\link{make_regression_base_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Internals}
