% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thr_test_het.R
\name{thr_test_het}
\alias{thr_test_het}
\title{Threshold Test under Heteroskedasticity}
\usage{
thr_test_het(
  df,
  yi,
  xi,
  qi,
  var.names = colnames(df),
  trim_per = 0.15,
  rep = 1000,
  cr = 0.95,
  graph = TRUE,
  quick = 2
)
}
\arguments{
\item{df}{Data frame.}

\item{yi}{Integer or character; index or column name of dependent (y)
variable in \code{df}.}

\item{xi}{Integer or character vector; indexes or column names of
independent (x) variables in \code{df}.}

\item{qi}{Integer or character; index or column name of threshold (q)
variable in \code{df}.}

\item{var.names}{Character vector; variable names with
\code{length(var.names) == ncol(df)}
corresponding to columns in \code{df} to be used in threshold regression
table. Default is \code{colnames(df)}.}

\item{trim_per}{Numeric; percentage of sample to trim from ends.
Default is \code{trim_per = .15}.}

\item{rep}{Integer; number of bootstrap replications. Default is
\code{rep = 1000}.}

\item{cr}{Numeric; confidence level used to plot the critical value in the
graph. It is not used elsewhere in the analysis. Default is
\code{cr = .95}.}

\item{graph}{Logical; graph indicator.
Set \code{TRUE} (default) to view the graph of the likelihood;
set \code{FALSE} otherwise.}

\item{quick}{Integer; indicator of method used for bootstrap.
Set \code{quick = 1} for quick computation of asymptotic distribution.
This method is not a proper bootstrap and may result in excess rejections.
It also uses more memory.
Set \code{quick = 2} (default) for a better bootstrap procedure,
which also uses less memory, but is more time consuming.}
}
\value{
A list with components:
    \describe{
    \item{\code{f_test}}{the value of Maximal (Quandt) F-statistic.}
    \item{\code{p_value}}{the bootstrap p-value.}
    }
}
\description{
Computes a test for a threshold in linear regression under heteroskedasticity.
}
\details{
\enumerate{
    \item Do not include a constant in the independent variables;
          the function automatically adds an intercept to the regression.
    \item There are two bootstrap methods which the function can use.

          The first method, obtained by setting \code{quick = 1},
          is the method presented in the paper
          Hansen, B. E. (1996). Inference When a Nuisance Parameter is Not
          Identified Under the Null Hypothesis.
          \emph{Econometrica}, 64(2):413-430.
          \url{https://www.ssc.wisc.edu/~bhansen/papers/ecnmt_96.pdf},
          which simulates the asymptotic null distribution.
          A computational shortcut is also taken which speeds computational
          time, at the cost of greater memory usage, so may not be possible
          for large data sets.

          The second method, obtained by setting \code{quick = 2},
          is a "fixed regressor bootstrap", which is quite close.
          The difference is that the bootstrap procedure calculates
          the variance-covariance matrix in each bootstrap replication.
          This results in a better finite sample approximation.
          The cost is greater computation time.

          The function is set by default to use the second method
          (\code{quick = 2}), which has better sampling properties.
          If computational time is a concern, switch to the first method
          (\code{quick = 1}). If an "out of workspace memory" message appears,
          switch back to \code{quick = 2}.
    }
}
\examples{
\donttest{
## Performs part of the empirical work reported in Hansen (2000)
data <- dur_john
output <- thr_test_het(data, 1, 2:5, 6)

output$f_test
output$p_value
}


}
\references{
Hansen, B. E. (2000). Sample splitting and threshold estimation.
    \emph{Econometrica}, 68(3):575--603.
    \url{https://doi.org/10.1111/1468-0262.00124}.
    \url{https://www.ssc.wisc.edu/~bhansen/papers/ecnmt_00.pdf}.
}
\seealso{
\code{\link{thr_test_hom}} for threshold test under homoskedasticity,
    \code{\link{thr_est}} for threshold estimation.
}
\author{
Marcel Kremer, \email{marcel.kremer@uni-due.de}

Bruce E. Hansen, \email{behansen@wisc.edu}
}
\keyword{htest}
\keyword{models}
\keyword{ts}
