% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{edgecov.ages-ergmTerm}
\alias{edgecov.ages-ergmTerm}
\alias{InitErgmTerm.edgecov.ages}
\title{Weighted sum of ages of extant ties}
\usage{
# binary: edgecov.ages(x, attrname=NULL)
}
\arguments{
\item{x, attrname}{either a square matrix of covariates, one for
each possible edge in the network, the name of a network
attribute of covariates, or a network; if the latter, or if the
network attribute named by \code{x} is itself a network, optional
argument \code{attrname} provides the name of the quantitative edge
attribute to use for covariate values (in this case, missing
edges in \code{x} are assigned a covariate value of zero).}
}
\description{
Weighted sum of ages of extant ties
}
\details{
This term adds one statistic equaling sum, over all ties
present in the network, of the amount of time elapsed since
formation, multiplied by a dyadic covariate.

"Weights" can be negative.

Unlike \code{\link[=edgecov.mean.age-ergmTerm]{edgecov.mean.age}} , this statistic is well-defined on
an empty network. However, if used as a target, it appears to
produce highly biased dissolution parameter estimates if the goal
is to get an intended average duration.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "edgecov.ages", "subsection")}
}
\concept{durational}
