% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.class.id0}
\alias{get.class.id0}
\title{Convert Frequency to Character and Class Id}
\usage{
get.class.id0(frequency)
}
\arguments{
\item{frequency}{The value of the frequency, which must be an \code{ldtf} object returned from the \code{f.?} functions.}
}
\value{
A list with the following items:
\itemize{
\item \strong{value}: The string representation of the frequency. If you only want this, use the \code{as.character()} function.
\item \strong{day}: The class Id of this frequency. If you only want this, use the \code{\link{get.class.id}} function.
\item \strong{classType}: The type of the class.
}
}
\description{
This function returns the output of the \link{as.character.ldtf} and \link{get.class.id} functions.
}
\examples{

freq <- f.x.times.a.day(f.daily(c(2023,5,16)),13, 12)
freq_class_id <- get.class.id0(freq)

freq1 <- f.monthly(2020,3)
freq1_class_id <- get.class.id0(freq1)
}
\seealso{
\code{\link{get.class.id}}
}
