% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_stocks.R
\name{ref_stocks}
\alias{ref_stocks}
\title{Reference Data Accessor for Stocks from \sQuote{twelvedata}}
\usage{
ref_stocks(
  sym = "",
  as = c("data.frame", "raw"),
  exchange = "",
  country = "",
  type = c(NA_character_, "EQUITY", "Common", "Common Stock",
    "American Depositary Receipt", "Real Estate Investment Trust (REIT)", "Unit", "GDR",
    "Closed-end Fund", "ETF", "Depositary Receipt", "Preferred Stock",
    "Limited Partnership", "OTHER_SECURITY_TYPE", "Warrant", "STRUCTURED_PRODUCT",
    "Exchange-traded Note", "Right", "FUND", "Trust", "Index",
    "Unit Of Beneficial Interest", "MUTUALFUND", "New York Registered Shares"),
  apikey
)
}
\arguments{
\item{sym}{(optional, character) A (single or vector) symbol understood by the backend as a stock
symbol, foreign exchange pair, or more. See the \sQuote{twelvedata} documentation for
details on what is covered.}

\item{as}{(optional, character) A selector for the desired output format: one of
\dQuote{data.frame} (the default) or or \dQuote{raw}.}

\item{exchange}{(optional, character) A selection of the exchange. Default value is unset.}

\item{country}{(optional, character) A selection of the country exchanges. Default value is unset.}

\item{type}{(optional, character) A valid security type selection, if set it must be one of
\code{formals(ref_stock)$type}, with \code{NA} as default.}

\item{apikey}{(optional character) An API key override, if missing a value cached from
package startup is used. The startup looks for either a file in the per-package config
directory provided by \code{tools::R_user_dir} (for R 4.0.0 or later), or the
\code{TWELVEDATA_API_KEY} variable.}
}
\value{
The requested data is returned as a \code{data.frame} object.
}
\description{
Retrieve Reference Data for Stocks from \sQuote{twelvedata}
}
\details{
\code{ref_stocks}.
}
\seealso{
\url{https://twelvedata.com/docs}
}
