% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_test.R
\name{tar_test}
\alias{tar_test}
\title{Test code in a temporary directory.}
\usage{
tar_test(label, code)
}
\arguments{
\item{label}{Character of length 1, label for the test.}

\item{code}{User-defined code for the test.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Runs a \code{test_that()} unit test inside a temporary
directory to avoid writing to the user's file space.
This helps ensure compliance with CRAN policies.
Also isolates \code{tar_option_set()}
options and environment variables specific to \code{targets}
and skips the test on Solaris.
Useful for writing tests for
\href{https://wlandau.github.io/targetopia/}{targetopia} packages
(extensions to \code{targets} tailored to specific use cases).
}
\examples{
tar_test("example test", {
  testing_variable_cafecfcb <- "only defined inside tar_test()"
  file.create("only_exists_in_tar_test")
})
exists("testing_variable_cafecfcb")
file.exists("only_exists_in_tar_test")
}
\seealso{
Other utilities to extend targets: 
\code{\link{tar_assert}},
\code{\link{tar_condition}},
\code{\link{tar_language}}
}
\concept{utilities to extend targets}
