## ----style, echo = FALSE, results = 'asis'----------------
BiocStyle::markdown()
options(width=60, max.print=1000)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")), 
    tidy.opts=list(width.cutoff=60), tidy=TRUE)

## ----setup, echo=FALSE, messages=FALSE, warnings=FALSE----
suppressPackageStartupMessages({
    library(systemPipeRdata)
})

## ----install, eval=FALSE----------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("systemPipeRdata")

## ----install_devel, eval=FALSE----------------------------
#  BiocManager::install("systemPipeRdata", version = "devel", build_vignettes=TRUE,
#                       dependencies=TRUE)  # Installs Devel version from Bioconductor

## ----load_systemPipeRdata, eval=TRUE, messages=FALSE, warnings=FALSE----
library("systemPipeRdata") # Loads the package

## ----documentation_systemPipeRdata, eval=FALSE------------
#  library(help="systemPipeRdata") # Lists package info
#  vignette("systemPipeRdata") # Opens vignette

## ----generate_workenvir, eval=FALSE-----------------------
#  genWorkenvir(workflow="systemPipeR/SPrnaseq", mydirname="rnaseq")
#  setwd("rnaseq")

## ----project_rnaseq, eval=FALSE---------------------------
#  sal <- SPRproject()
#  sal <- importWF(sal, file_path = "systemPipeVARseq.Rmd", verbose = FALSE)

## ----run_rnaseq, eval=FALSE-------------------------------
#  sal <- runWF(sal)

## ----plot_rnaseq, eval=FALSE------------------------------
#  plotWF(sal)

## ----report_rnaseq, eval=FALSE----------------------------
#  sal <- renderLogs(sal)

## ----reporttech_rnaseq, eval=FALSE------------------------
#  sal <- renderReport(sal)

## ----eval=FALSE, tidy=FALSE-------------------------------
#  availableWF(github = TRUE)

## ----eval=FALSE, tidy=FALSE-------------------------------
#  genWorkenvir(workflow="systemPipeR/SPrnaseq", mydirname="NULL")
#  setwd("SPrnaseq")

## ----eval=FALSE, tidy=FALSE-------------------------------
#  genWorkenvir(workflow="systemPipeR/SPrnaseq", ref = "singleMachine")
#  setwd("SPrnaseq")

## ----eval=FALSE, tidy=FALSE-------------------------------
#  genWorkenvir(workflow="systemPipeR/SPrnaseq", url = "https://raw.githubusercontent.com/systemPipeR/systemPipeRNAseq/cluster/vignettes/systemPipeRNAseq.Rmd",
#               urlname = "rnaseq_V-cluster.Rmd")
#  setwd("rnaseq")

## ----return_samplepaths, eval=TRUE------------------------
pathList()[1:2]

## ----sessionInfo------------------------------------------
sessionInfo()

