## ----style, echo = FALSE, results = 'asis'----------------
BiocStyle::markdown()
options(width=60, max.print=1000)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")), 
    tidy.opts=list(width.cutoff=60), tidy=TRUE)

## ----setup, echo=FALSE, message=FALSE, warning=FALSE, eval=FALSE----
#  suppressPackageStartupMessages({
#      library(systemPipeR)
#  })

## ----create_workflow, message=FALSE, eval=FALSE-----------
#  library(systemPipeR)
#  sal <- SPRproject()
#  sal

## ----load_packages, eval=FALSE, spr=TRUE------------------
#  cat(crayon::blue$bold("To use this workflow, following R packages are expected:\n"))
#  cat(c("'rBLAST", "readr\n"), sep = "', '")
#  ###pre-end
#  appendStep(sal) <- LineWise(
#      code = {
#          library(systemPipeR)
#          library(rBLAST)
#      },
#      step_name = "load_packages"
#  )

## ----test_blast, eval=FALSE, spr=TRUE---------------------
#  # Here, the dataset is downloaded. If you already have the data locally, change URL to local path.
#  appendStep(sal) <- LineWise(
#      code = {
#          # If you have a modular system, use following line
#          moduleload("ncbi-blast")
#          # If not, comment out line above you need to install BLAST and configure the PATH.
#          blast_check <- tryCMD("blastn", silent = TRUE)
#          if(blast_check  == "error") stop("Check your BLAST installation path.")
#      },
#      step_name = "test_blast",
#      dependency = "load_packages"
#  )

## ----load_query, eval=FALSE, spr=TRUE---------------------
#  appendStep(sal) <- LineWise(
#      code = {
#          query <- readDNAStringSet('data/example.fasta')
#      },
#      step_name = "load_query",
#      dependency = "test_blast"
#  )

## ----build_genome_db, eval=FALSE, spr=TRUE----------------
#  
#  appendStep(sal) <- LineWise(
#      code = {
#          reference <- 'data/tair10.fasta'
#          # this command prepare BLAST-able database of genome
#          makeblastdb(reference, dbtype='nucl')
#      },
#      step_name = "build_genome_db",
#      dependency = "load_query"
#  )

## ----blast_genome, eval=FALSE, spr=TRUE-------------------
#  appendStep(sal) <- LineWise(
#      code = {
#          bl_tair10 <- blast(db = reference, type='blastn')
#          cl_tair10 <- predict(bl_tair10, query)
#          readr::write_csv(cl_tair10, "results/blast_tair10.csv")
#      },
#      step_name = "blast_genome",
#      dependency = "build_genome_db"
#  )

## ----blast_db, eval=FALSE, spr=TRUE-----------------------
#  appendStep(sal) <- LineWise(
#      code = {
#          bl_covid <- blast(
#              db = '/srv/projects/db/ncbi/preformatted/20220131/Betacoronavirus',
#              type='blastn'
#          )
#          cl_covid <- predict(bl_covid, query[9:10])
#          readr::write_csv(cl_covid, "results/blast_covid.csv")
#      },
#      step_name = "blast_db",
#      dependency = "load_query"
#  )

## ----blast_nt, eval=FALSE, spr=TRUE-----------------------
#  appendStep(sal) <- LineWise(
#      code = {
#          bl_nt <- blast(db = '/srv/projects/db/ncbi/preformatted/20220131/nt', type='blastn')
#          cl_nt <- predict(bl_nt, query[5])
#          readr::write_csv(cl_nt, "results/blast_nt.csv")
#      },
#      step_name = "blast_nt",
#      dependency = "load_query",
#      run_step = "optional"
#  )

## ----wf_session, eval=FALSE, spr=TRUE---------------------
#  appendStep(sal) <- LineWise(
#      code = {
#          sessionInfo()
#      },
#      step_name = "wf_session",
#      dependency = "blast_db")

## ----runWF, eval=FALSE------------------------------------
#  sal <- runWF(sal, run_step = "mandatory") # remove `run_step` to run all steps to include optional steps

## ----list_tools-------------------------------------------
if(file.exists(file.path(".SPRproject", "SYSargsList.yml"))) {
    local({
        sal <- systemPipeR::SPRproject(resume = TRUE)
        systemPipeR::listCmdTools(sal)
        systemPipeR::listCmdModules(sal)
    })
} else {
    cat(crayon::blue$bold("Tools and modules required by this workflow are:\n"))
    cat(c("bowtie2/2.4.5", "samtools/1.14", "macs2"), sep = "\n")
}

## ----report_session_info, eval=TRUE-----------------------
sessionInfo()

