\name{writeTargets}
\alias{writeTargets}
\title{
Write updated targets out to file from \code{SYSargsList}
}
\description{
Convenience write function for generating targets files containing the paths to 
files generated by input processes. These processes can be commandline- 
or R-based software. Typically, the paths to the inputs are stored in the 
targets infile \code{targetsWF(sysargs)} for \code{SYSargsList} objects. 
Note: by default the function cannot overwrite any existing files. If a file 
exists then the user has to explicitly remove it or set \code{overwrite=TRUE}. 
}
\usage{
writeTargets(sysargs, step, file = "default", silent = FALSE, overwrite = FALSE)
}
\arguments{
  \item{sysargs}{
Object of class \code{SYSargsList}.
}
  \item{step}{
    character with the step name. To check all the names, please 
    use \code{stepName(sysargs)}.
}
  \item{file}{
    Name and path of the output file. If set to "default" then the name of the 
    output file will have the pattern 'targets_<stepName>.txt'.
}
  \item{silent}{
    If set to \code{TRUE}, all messages returned by the function will be suppressed.
}
  \item{overwrite}{
    If set to \code{TRUE}, existing files of same name will be overwritten.
}
}
\value{
    Writes tabular targes files containing the header/comment lines from 
    \code{stepsWF(sysargs)[[step]][["targetsheader"]]} and the 
    columns from \code{targetsWF(sysargs)[[step]]}.
}
\author{
Daniela Cassol 
}

\examples{
## Construct SYSargsList object from Rmd file
sal <- SPRproject(overwrite=TRUE)
targetspath <- system.file("extdata/cwl/example/targets_example.txt", package="systemPipeR")

## Constructor and `appendStep<-`
appendStep(sal) <- SYSargsList(step_name = "echo", 
                               targets=targetspath, dir=TRUE,
                               wf_file="example/workflow_example.cwl", input_file="example/example.yml", 
                               dir_path = system.file("extdata/cwl", package="systemPipeR"),
                               inputvars = c(Message = "_STRING_", SampleName = "_SAMPLE_"))
appendStep(sal) <- LineWise(code = {
                            hello <- lapply(getColumn(sal, step=1, 'outfiles'), function(x) yaml::read_yaml(x))
                            }, 
                            step_name = "R_read", 
                            dependency = "echo")
writeTargets(sal, "echo")
}
\keyword{ utilities }
