\name{filterDEGs}
\alias{filterDEGs}
\title{
Filter and plot DEG results
}
\description{
Filters and plots DEG results for a given set of sample comparisons. The gene idenifiers of all (i) Up_or_Down, (ii) Up and (iii) Down regulated genes are stored as separate list components, while the corresponding summary statistics, stored in a fourth list component, is plotted in form of a stacked bar plot.
}
\usage{
filterDEGs(degDF, filter, plot = TRUE)
}
\arguments{
  \item{degDF}{
	\code{data.frame} generated by \code{run_edgeR}
}
  \item{filter}{
	Named vector with filter cutoffs of format \code{c(Fold=2, FDR=1)} where \code{Fold} refers to the fold change cutoff (unlogged) and \code{FDR} to the p-value cutoff.
}
  \item{plot}{
	Allows to turn plotting behavior on and off with default set to \code{TRUE}. 
}
}
\details{
Currently, there is no community standard available how to calculate fold
changes (here logFC) of genomic ranges, such as gene or feature ranges, to
unambiguously refer to them as features with increased or decreased read
abundandce; or in case of gene expression experiments to up or down regulated
genes, respectively. To be consistent within \code{systemPipeR}, the
corresponding functions, such as \code{filterDEGs}, use here the following
definition. Genomic ranges with positive logFC values are classified as
\code{up} and those with negative logFC values as \code{down}.  This means if a
comparison among two samples \code{a} and \code{b} is specified in the
corresponding targets file as \code{a-b} then the feature with a positive logFC
has a higher _normalized_ read count value in sample \code{a} than in sample
\code{b}, and vice versa. To inverse this assignment, users want to change the
specification of their chosen sample comparison(s) in the targets file
accordingly, e.g. change \code{a-b} to \code{b-a}. Alternatively, one can swap
the column order of the matrix assigned to the \code{cmp} argument of the
\code{run_edgeR} or \code{run_DESeq2} functions. Users should also be aware
that for logFC values close to zero (noise range), the direction of the fold
change (sign of logFC) can be very sensitive to minor differences in the
normalization method, while this assignment is much more robust for more
pronounced changes or higher absolute logFC values. 
}
\value{
Returns \code{list} with four components
  \item{UporDown}{List of up or down regulated gene/transcript indentifiers meeting the chosen filter settings for all comparisons defined in data frames \code{pval} and \code{log2FC}.}
  \item{Up}{Same as above but only for up regulated genes/transcript.}
  \item{Down}{Same as above but only for down regulated genes/transcript.}
}
\author{
Thomas Girke
}
\seealso{
\code{run_edgeR}
}
\examples{
targetspath <- system.file("extdata", "targets.txt", package="systemPipeR")
targets <- read.delim(targetspath, comment.char = "#")
cmp <- readComp(file=targetspath, format="matrix", delim="-")
countfile <- system.file("extdata", "countDFeByg.xls", package="systemPipeR")
countDF <- read.delim(countfile, row.names=1)
edgeDF <- run_edgeR(countDF=countDF, targets=targets, cmp=cmp[[1]], independent=FALSE, mdsplot="")
pval <- edgeDF[, grep("_FDR$", colnames(edgeDF)), drop=FALSE]
fold <- edgeDF[, grep("_logFC$", colnames(edgeDF)), drop=FALSE]
DEG_list <- filterDEGs(degDF=edgeDF, filter=c(Fold=2, FDR=10))
names(DEG_list)
DEG_list$Summary
}
\keyword{utilities}
