% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{S}
\alias{S}
\alias{Basic}
\alias{Symbol}
\alias{Constant}
\alias{Real}
\title{Converting R object to Basic}
\usage{
S(x)

Basic(x)

Symbol(x)

Constant(x)

Real(x, prec = NULL)
}
\arguments{
\item{x}{A R object.}

\item{prec}{If supplied, the argument will be parsed as a Basic object of type 
RealMPFR.}
}
\value{
A \code{Basic} S4 object.
}
\description{
`S` and `Basic` converts a R object to a Basic object. `Symbol`, `Real` and `Constant`
construct a Basic object with type "Symbol", "RealDouble"/"RealMPFR"
and "Constant", respectively.
}
\details{
For double vector, `S` will check whether it is a whole number -- if true,
it will be converted to a Integer type. If this behavior is not desired,
you can use `Basic` or `as(x, "Basic")`.
}
\examples{
S("(x + y)^2")
S(~ (x + y)^2)
S(NaN)
S(42)
Basic(42)
as(42, "Basic")
pi <- Constant("pi")
evalf(pi)
if (symengine_have_component("mpfr"))
    evalf(pi, 300)
Real(42)
if (symengine_have_component("mpfr"))
    Real(42, prec = 140)
}
