% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{rep4dat}
\alias{rep4dat}
\title{Repeat the Rows of a Data Frame according to a Frequency Column}
\usage{
rep4dat(dat, freqName = "Freq")
}
\arguments{
\item{dat}{A data frame.}

\item{freqName}{Character specifying the name of the frequency column.}
}
\value{
A data frame.
}
\description{
A helper function for repeating the rows a data frame according to a frequency column.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
tab_SndT_Fra <- table(SndT_Fra)
dat_SndT_Fra <- as.data.frame(tab_SndT_Fra)
rep4dat(dat_SndT_Fra)
}
