% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbenchmark.R
\name{rbenchmark}
\alias{rbenchmark}
\alias{print.rbenchmark}
\title{R Benchmark 2.6}
\usage{
rbenchmark(runs = 3L)

\method{print}{rbenchmark}(x, ...)
}
\arguments{
\item{runs}{Number of times each test is run (3 by default).}

\item{x}{A \strong{rbenchmark} object}

\item{...}{Further arguments (not used yet)}
}
\value{
An \strong{rbenchmark} object with the timing of all 15 tests.
}
\description{
This is a benchmark of base R with 15 tests of various common (matrix)
calculations and programming techniques like loops, vector calculation,
recursion, etc.
}
\details{
This code is reworked from the R Benchmark 2.5 adapted by Simon Urbanek
(https://mac.r-project.org/benchmarks/) from my initial implementation ,
itself inspired from Matlab code by Stephan Steinhaus. In comparison to
version 2.5, this one is included in a function and returns a \strong{rbenchmark}
objects that prints in a very similar way to the original code. However,
only functions from base R packages (including {stats} and {utils}) are used,
where previous versions also used recommended package {Matrix} and possibly
CRAN package {SuppDists}. Expect some slight differences.

Some tests in sections I and II use BLAS/LAPACK code. Their results are
heavily dependent on the BLAS implementation that you choose. The default R
BLAS is single-threaded and is rather slow, but it well tested and certified
to be accurate. Use a good multi-threaded BLAS alternative for much improved
results (sometimes 10x faster or more), like ATLAS, OpenBLAS, Intel MKL, ...
See https://cran.r-project.org/web/packages/gcbd/vignettes/gcbd.pdf. Use
\code{utils::sessionInfo()} to know which BLAS version R currently uses.

Beside multi-threaded BLAS, all tests are single-threaded. This benchmark
does not test full parallel potential of R. Also, other key aspects like read
and write of data on disk of from databases are not tested. As usual, take
these artificial benchmarks with a grain of salt: it may not represent the
speed of your actual calculations since it depends mainly on the functions
you use and on your programming style...
}
\examples{
\dontrun{
  # This can be slow
  rbenchmark()
}
}
