% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aka.R
\name{aka}
\alias{aka}
\title{Create an alias (also known as) for an object whose comment and/or original help page can be viewed with .?obj.}
\usage{
aka(obj, alias = NULL, comment = "")
}
\arguments{
\item{obj}{An R object.}

\item{alias}{The full qualified name of the alias object whose help
page should be retained as \code{pkg::name}. If \code{NULL} (by default), use \code{obj}.}

\item{comment}{A comment to place in \code{obj} (will also be printed when calling
\code{.?obj}).}
}
\value{
The original \code{obj} with the \code{comment} attribute set or replaced with
\verb{comment =} plus a \code{src} attribute set to \verb{alias =}
}
\description{
When a function or object is renamed, the link to its original
help page is lost in R. Using \code{aka()} (also known as) with correct \verb{alias=}
allows to keep track of the original help page and get it with \code{.?obj}.
Moreover, one can also add a short comment message that is displayed at the
same time in the R console.
}
\examples{
# Say you prefer is.true() similar to is.na() or is.null()
# but R provides isTRUE().
library(svMisc)
is.true <- aka(isTRUE)
# This way, you still got access to the right help page for is.true()
\dontrun{
.?is.true
}
}
