# this file is part of stringi
# generate binary property match code for uchar.cpp
# M.Gagolewski, 2013-06-01


require('stringi')



binprops <- c(
   "ALPHABETIC"="UCHAR_ALPHABETIC",
   "ASCII_HEX_DIGIT"="UCHAR_ASCII_HEX_DIGIT",
   "BIDI_CONTROL"="UCHAR_BIDI_CONTROL",
   "BIDI_MIRRORED"="UCHAR_BIDI_MIRRORED",
   "DASH"="UCHAR_DASH",
   "DEFAULT_IGNORABLE_CODE_POINT"="UCHAR_DEFAULT_IGNORABLE_CODE_POINT",
   "DEPRECATED"="UCHAR_DEPRECATED",
   "DIACRITIC"="UCHAR_DIACRITIC",
   "EXTENDER"="UCHAR_EXTENDER",
   "FULL_COMPOSITION_EXCLUSION"="UCHAR_FULL_COMPOSITION_EXCLUSION",
   "GRAPHEME_BASE"="UCHAR_GRAPHEME_BASE",
   "GRAPHEME_EXTEND"="UCHAR_GRAPHEME_EXTEND",
   "GRAPHEME_LINK"="UCHAR_GRAPHEME_LINK",
   "HEX_DIGIT"="UCHAR_HEX_DIGIT",
   "HYPHEN"="UCHAR_HYPHEN",
   "ID_CONTINUE"="UCHAR_ID_CONTINUE",
   "ID_START"="UCHAR_ID_START",
   "IDEOGRAPHIC"="UCHAR_IDEOGRAPHIC",
   "IDS_BINARY_OPERATOR"="UCHAR_IDS_BINARY_OPERATOR",
   "IDS_TRINARY_OPERATOR"="UCHAR_IDS_TRINARY_OPERATOR",
   "JOIN_CONTROL"="UCHAR_JOIN_CONTROL",
   "LOGICAL_ORDER_EXCEPTION"="UCHAR_LOGICAL_ORDER_EXCEPTION",
   "LOWERCASE"="UCHAR_LOWERCASE",
   "MATH"="UCHAR_MATH",
   "NONCHARACTER_CODE_POINT"="UCHAR_NONCHARACTER_CODE_POINT",
   "QUOTATION_MARK"="UCHAR_QUOTATION_MARK",
   "RADICAL"="UCHAR_RADICAL",
   "SOFT_DOTTED"="UCHAR_SOFT_DOTTED",
   "TERMINAL_PUNCTUATION"="UCHAR_TERMINAL_PUNCTUATION",
   "UNIFIED_IDEOGRAPH"="UCHAR_UNIFIED_IDEOGRAPH",
   "UPPERCASE"="UCHAR_UPPERCASE",
   "WHITE_SPACE"="UCHAR_WHITE_SPACE",
   "XID_CONTINUE"="UCHAR_XID_CONTINUE",
   "XID_START"="UCHAR_XID_START",
   "CASE_SENSITIVE"="UCHAR_CASE_SENSITIVE",
   "S_TERM"="UCHAR_S_TERM",
   "VARIATION_SELECTOR"="UCHAR_VARIATION_SELECTOR",
   "NFD_INERT"="UCHAR_NFD_INERT",
   "NFKD_INERT"="UCHAR_NFKD_INERT",
   "NFC_INERT"="UCHAR_NFC_INERT",
   "NFKC_INERT"="UCHAR_NFKC_INERT",
   "SEGMENT_STARTER"="UCHAR_SEGMENT_STARTER",
   "PATTERN_SYNTAX"="UCHAR_PATTERN_SYNTAX",
   "PATTERN_WHITE_SPACE"="UCHAR_PATTERN_WHITE_SPACE",
   "POSIX_ALNUM"="UCHAR_POSIX_ALNUM",
   "POSIX_BLANK"="UCHAR_POSIX_BLANK",
   "POSIX_GRAPH"="UCHAR_POSIX_GRAPH",
   "POSIX_PRINT"="UCHAR_POSIX_PRINT",
   "POSIX_XDIGIT"="UCHAR_POSIX_XDIGIT",
   "CASED"="UCHAR_CASED",
   "CASE_IGNORABLE"="UCHAR_CASE_IGNORABLE",
   "CHANGES_WHEN_LOWERCASED"="UCHAR_CHANGES_WHEN_LOWERCASED",
   "CHANGES_WHEN_UPPERCASED"="UCHAR_CHANGES_WHEN_UPPERCASED",
   "CHANGES_WHEN_TITLECASED"="UCHAR_CHANGES_WHEN_TITLECASED",
   "CHANGES_WHEN_CASEFOLDED"="UCHAR_CHANGES_WHEN_CASEFOLDED",
   "CHANGES_WHEN_CASEMAPPED"="UCHAR_CHANGES_WHEN_CASEMAPPED",
   "CHANGES_WHEN_NFKC_CASEFOLDED"="UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED"
)

binprops_normalized = c(
   "ALPHABETIC",
   "ASCIIHEXDIGIT",
   "BIDICONTROL",
   "BIDIMIRRORED",
   "DASH",
   "DEFAULTIGNORABLECODEPOINT",
   "DEPRECATED",
   "DIACRITIC",
   "EXTENDER",
   "FULLCOMPOSITIONEXCLUSION",
   "GRAPHEMEBASE",
   "GRAPHEMEEXTEND",
   "GRAPHEMELINK",
   "HEXDIGIT",
   "HYPHEN",
   "IDCONTINUE",
   "IDSTART",
   "IDEOGRAPHIC",
   "IDSBINARYOPERATOR",
   "IDSTRINARYOPERATOR",
   "JOINCONTROL",
   "LOGICALORDEREXCEPTION",
   "LOWERCASE",
   "MATH",
   "NONCHARACTERCODEPOINT",
   "QUOTATIONMARK",
   "RADICAL",
   "SOFTDOTTED",
   "TERMINALPUNCTUATION",
   "UNIFIEDIDEOGRAPH",
   "UPPERCASE",
   "WHITESPACE",
   "XIDCONTINUE",
   "XIDSTART",
   "CASESENSITIVE",
   "STERM",
   "VARIATIONSELECTOR",
   "NFDINERT",
   "NFKDINERT",
   "NFCINERT",
   "NFKCINERT",
   "SEGMENTSTARTER",
   "PATTERNSYNTAX",
   "PATTERNWHITESPACE",
   "POSIXALNUM",
   "POSIXBLANK",
   "POSIXGRAPH",
   "POSIXPRINT",
   "POSIXXDIGIT",
   "CASED",
   "CASEIGNORABLE",
   "CHANGESWHENLOWERCASED",
   "CHANGESWHENUPPERCASED",
   "CHANGESWHENTITLECASED",
   "CHANGESWHENCASEFOLDED",
   "CHANGESWHENCASEMAPPED",
   "CHANGESWHENNFKCCASEFOLDED"
)

ord <- stri_order(binprops_normalized)
binprops <- binprops[ord]
binprops_normalized <- binprops_normalized[ord]

cat(stri_wrap(stri_join("\"", binprops_normalized, "\"", collapse=", "), 80))
cat('\n\n\n')
cat(stri_wrap(stri_join("\"", names(binprops), "\"", collapse=", "), 80))
cat('\n\n\n')
cat(stri_wrap(stri_join(binprops, collapse=", "), 80))
cat('\n\n\n')

print(length(binprops))
print(max(stri_length(names(binprops))))
