% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.agree.3rater}
\alias{ci.agree.3rater}
\title{Computes confidence intervals for a 3-rater design with dichotomous ratings}
\usage{
ci.agree.3rater(alpha, f)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of frequency counts from 2x2x2 table where
f = {\code{[}}f111, f112, f121, f122, f211, f212, f221, f222{\verb{]}}
first subscript represents rating of rater 1,
second subscript represents rating of rater 2,
third subscript represents rating of rater 3}
}
\value{
Returns a 3-row matrix. The rows are:
\itemize{
\item G{1,2}: G-index for raters 1 and 2
\item G{1,3}: G-index for raters 1 and 3
\item G{2,3}: G-index for raters 2 and 3
\item G{1,2}-{1,3}: difference in G{1,2} and G{1,3}
\item G{1,2}-{2,3}: difference in G{1,2} and G{2,3}
\item G{2,3}-{1,3}: difference in G{2,3} and G{1,3}
\item G(3): G-index of unanimous agreement for all three raters
}

The columns are:
\itemize{
\item Estimate - estimate of G-index (two-rater, difference, or unanimous)
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for a G-index of agreement for
all pairs of raters in a 3-rater design with a dichotomous rating, and
computes adjusted Wald confidence intervals for differences of all pairs of
G agreement. An adjusted Wald confidence interval for unanimous G agreement
among the three raters also is computed. In the three-rater design,
unanimous G agreement is equal to the average of all pairs of G agreement.
}
\examples{
f <- c(100, 6, 4, 40, 20, 1, 9, 120)
ci.agree.3rater(.05, f)

# Should return:
#                  Estimate          LL         UL
# G{1,2}         0.56666667  0.46601839  0.6524027
# G{1,3}         0.50000000  0.39564646  0.5911956
# G{2,3}         0.86666667  0.79701213  0.9135142
# G{1,2}-{1,3}  0.06666667  0.00580397  0.1266464
# G{1,2}-{2,3} -0.30000000 -0.40683919 -0.1891873
# G{2,3}-{1,3} -0.36666667 -0.46222023 -0.2662566
# G(3)           0.64444444  0.57382971  0.7068720
 

}
\references{
\insertRef{Bonett2022}{statpsych}
}
