\name{quench}
\Rdversion{1.1}
\alias{quench}

\title{Conditional Simulation Adjuster Via Quenching Algorithm}

\description{
The function adjusts a simulated random field generated by the \code{\link{sim}} function.
}

\usage{quench(x, data, coords, sim, GA = FALSE, optype = c("param", 
       "fullprobs", "semiprobs", "coordprobs"), max.it = 1000,
       knn = 12)}

\arguments{
%%        x a multi_tpfit object
%%     data vector of data
%%   coords coordinates matrix
%%      sim simulation results (tipically an "spsim" object)
%%       GA boolean (if TRUE genetic algorithm is applied rather than simulated annealing)
%%   optype character with the objective function to minimize after the simulation
%%   max.it maximum number of iteration for the optimization method
%%      knn number of k-nearest neighbours
  \item{x}{an object of the class \code{multi_tpfit}, typically with the output of the function \code{\link{multi_tpfit}}.}
  \item{data}{a categorical data vector of length \eqn{n}{n}.}
  \item{coords}{an \eqn{n \times d}{n x d} matrix where each row denotes the \eqn{d}{d}-D coordinates of data locations.}
  \item{sim}{an object of the class \code{spsim}, it is usually the output of the function \code{\link{sim}}.}
  \item{GA}{a logical value; if \code{TRUE}, the function performs the Genetic Algorithm instead of the Simulated Annealing.}
  \item{optype}{a character which denotes the objective function to compute when the optimization is performed.}
  \item{max.it}{a numerical value which specifies the maximum number of iterations to stop the optimization algorithm. For proper results, it should be a multiple of the number of simulation points.}
  \item{knn}{an integer value which specifies the number of k-nearest neighbours for each simulation point. An optimal number is between 4 and 12. If \code{NULL} all observations are considered (just for very small dataset!!). It is \code{12} by default.}
}

\details{
This method perform a simulated annealing or a genetic algorithm to modify the simulation results, in order to reduce artifacts effects. In practice, each simulated configuration is adjusted to reach a pattern similar to the observed sample data. There are several objective functions for this purpose, by setting \code{optype} equal to \code{"param"} the optimization is performed through parametric methods. The alternatives \code{"fullprobs"} and \code{"semiprobs"} are based on transition probabilities computed among simulation points, while the option \code{"coordprobs"} is based on transition probabilities calculated among observation and simulation points.

This procedure should be executed by setting \code{max.it} equal at least to the simulation grid size, or its multiples.
}

\value{A data frame containing the simulation grid, the simulated random field, predicted values and the approximated probabilities.}

\references{Carle, S. F., Fogg, G. E. (1996) Transition Probability-Based Indicator Geostatistics. \emph{Mathematical Geosciences}, \bold{28}(4), 453-476.

Carle, S. F. (1999) T-PROGS: Transition Probability Geostatistical Software. University of California, Davis.

Sartore, L. (2010) Geostatistical models for 3-D data. M.Phil. thesis, Ca' Foscari University of Venice.

%Tolosana-Delgado, R., Pawlowsky-Glahn, V., Egozcue, J.J. (2008) Indicator Kriging without Order Relation Violations. \emph{Mathematical Geosciences}, \bold{40}(3), 327-347.

Weise, T. (2009) \emph{Global Optimization Algorithms - Theory and Application}. \url{https://archive.org/details/Thomas_Weise__Global_Optimization_Algorithms_Theory_and_Application}.}

\author{Luca Sartore \email{drwolf85@gmail.com}}
%%\note{
%%%%  ~~further notes~~
%%}

\seealso{\code{\link{sim_ck}}, \code{\link{sim_ik}}, \code{\link{sim_mcs}}, \code{\link{sim_path}}}

\examples{\donttest{
data(ACM)

# Model parameters estimation for the
# multinomial categorical simulation
x <- multi_tpfit(ACM$MAT5, ACM[, 1:3])

# Generate the simulation grid
mygrid <- list()
mygrid$X <- seq(min(ACM$X), max(ACM$X), length = 20)
mygrid$Y <- seq(min(ACM$Y), max(ACM$Y), length = 20)
mygrid$Z <- -40 * 0:9 - 1
mygrid <- as.matrix(expand.grid(mygrid$X, mygrid$Y, mygrid$Z))

# Simulate the random field through
# Ordinary Indicator Kriging algorithm
myOIKSim <- sim_ik(x, ACM$MAT5, ACM[, 1:3], mygrid)
 
# Perform the quenching algorithm 
# to adjust simulation
quench(x, ACM$MAT5, ACM[, 1:3], myOIKSim, optype = "coordprobs",
       max.it = 2, knn = 12) 
}}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{spatial}
\keyword{distribution}
