% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongon.R
\name{ep.tif}
\alias{ep.tif}
\title{Environmental predictors}
\format{
A geotiff file
}
\description{
A geotiff file (CRS: UTM zone 17S; EPSG:32717) with 117 rows and 117 columns:
\enumerate{
    \item{\code{dem}} {Digital elevation model (ASTER GDEM, LP DAAC 2012), see also [spDataLarge::dem].}
    \item{\code{ndvi}} {Normalized Differenced Vegetation index.}
    \item{\code{carea}} {Catchment area.}
    \item{\code{cslope}} {Catchment slope}
    }
The data is used in the "Ecology" chapter in Geocomputation with R.
See \url{https://geocompr.robinlovelace.net/eco.html} for details.
}
\examples{
system.file("raster/ep.tif", package = "spDataLarge")
}
\references{
LP DAAC (2012): Land Processes Distributed Active Archive Center, located
at the U.S. Geological Survey (USGS) Earth Resources Observation
and Science (EROS) Center. Available at: https://lpdaac.usgs.gov/
(last accessed 25 January 2012).

Muenchow, J., Brauning, A., Rodriguez, E.F. & von Wehrden, H. (2013):
Predictive mapping of species richness and plant species' distributions of a
Peruvian fog oasis along an altitudinal gradient. Biotropica 45, 5, 557-566,
doi: 10.1111/btp.12049.

Muenchow, J., Schratz, P., and A. Brenning. 2017. RQGIS: Integrating R with
QGIS for Statistical Geocomputing. The R Journal 9, 2, 409-428.
https://rjournal.github.io/archive/2017/RJ-2017-067/RJ-2017-067.pdf.
}
