% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongon.R
\name{dem.tif}
\alias{dem.tif}
\title{Digital elevation model (DEM) of the Mongón study area.}
\format{
A geotiff file
}
\description{
A raster geotiff (EPSG:32717) representing altitude
  (ASTER GDEM, LP DAAC 2012) with 117 rows and 117 columns: \describe{
  \item{dem}{Altitude in m asl.}. For more details, please refer to Muenchow et
  al. (2013).}.
   The data is used in the "Ecology" chapter in Geocomputation with R.
   See \url{https://geocompr.robinlovelace.net/eco.html} for details.
}
\examples{
system.file("raster/ndvi.tif", package = "spDataLarge")
}
\references{
Muenchow, J., Bräuning, A., Rodríguez, E.F. & von Wehrden, H.
(2013): Predictive mapping of species richness and plant species'
distributions of a Peruvian fog oasis along an altitudinal gradient.
Biotropica 45, 5, 557-566, doi: 10.1111/btp.12049.

LP DAAC (2012): Land Processes Distributed Active Archive Center, located at
the U.S. Geological Survey (USGS) Earth Resources Observation and Science
(EROS) Center. Available at: https://lpdaac.usgs.gov/ (last accessed 25
January 2012).
}
