% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundSeaWaterFryeAndPugh}
\alias{SpeedOfSoundSeaWaterFryeAndPugh}
\title{Calculation of speed of sound in sea water from Frye and Pugh 1971}
\source{
Frye, H.W. and Pugh, J.D. 1971
A new equation for the speed of sound in seawater
J. Acoust. Soc. Am., 50, 384-6.
}
\usage{
SpeedOfSoundSeaWaterFryeAndPugh(temperatureC, S, P)
}
\arguments{
\item{temperatureC,}{temperature from -3C to 30C}

\item{S,}{salinity from 33.1 to -36.6 per 1000}

\item{P,}{hydrostatic pressure from 1.033 to 984.3 kg/cm^2}
}
\value{
the speed of sound
}
\description{
Returns the speed of sound in sea water from Frye and Pugh 1971
}
\examples{
SpeedOfSoundSeaWaterFryeAndPugh(0, 30, 1.033)
}
\author{
Jose Gama
}
\references{
Frye, H.W. and Pugh, J.D. 1971
A new equation for the speed of sound in seawater
J. Acoust. Soc. Am., 50, 384-6.
}

