% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{risk_functions}
\alias{risk_functions}
\alias{custom_ROCR_risk}
\title{FACTORY RISK FUNCTION FOR ROCR PERFORMANCE MEASURES WITH BINARY OUTCOMES}
\usage{
custom_ROCR_risk(measure, cutoff = 0.5, name = NULL, ...)
}
\arguments{
\item{measure}{A character indicating which \code{ROCR} performance measure
to use for evaluation. The \code{measure} must be either cutoff-dependent
so a single value can be selected (e.g., "tpr"), or it's value is a scalar
(e.g., "aucpr"). For more information, see \code{\link[ROCR]{performance}}.}

\item{cutoff}{A numeric value specifying the cutoff for choosing a single
performance measure from the returned set. Only used for performance
measures that are cutoff-dependent and default is 0.5. See
\code{\link[ROCR]{performance}} for more detail.}

\item{name}{An optional character string for user to supply their desired
name for the performance measure, which will be used for naming subsequent
risk-related tables and metrics (e.g., \code{cv_risk} column names). When
\code{name} is not supplied, the \code{measure} will be used for naming.}

\item{...}{Optional arguments to specific \code{ROCR} performance
measures. See \code{\link[ROCR]{performance}} for more detail.}
}
\description{
Factory function for estimating an ROCR-based risk for a given ROCR measure,
and the risk is defined as one minus the performance measure.
}
\note{
This risk does not take into account weights. In order to use this
risk, it must first be instantiated with respect to the \pkg{ROCR}
performance measure of interest, and then the user-defined function can be
used.
}
