% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_solnp.R
\docType{class}
\name{Lrnr_solnp}
\alias{Lrnr_solnp}
\title{Nonlinear Optimization via Augmented Lagrange}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This meta-learner provides fitting procedures for any pairing of loss or risk
function and metalearner function, subject to constraints. The optimization
problem is solved by making use of \code{\link[Rsolnp]{solnp}}, using
Lagrange multipliers. An important note from the \code{\link[Rsolnp]{solnp}}
documentation states that the control parameters \code{tol} and \code{delta}
are key in getting any possibility of successful convergence, therefore it
is suggested that the user change these appropriately to reflect their
problem specification. For further details, consult the documentation of the
\pkg{Rsolnp} package.
}
\section{Parameters}{

\itemize{
\item \code{learner_function = metalearner_linear}: A function(alpha, X) that
takes a vector of covariates and a matrix of data and combines them
into a vector of predictions. See \code{\link{metalearners}} for
options.
\item \code{eval_function = loss_squared_error}: A function(pred, truth) that
takes prediction and truth vectors and returns a loss vector or a risk
scalar. See \code{\link{loss_functions}} and
\code{\link{risk_functions}} for options and more detail.
\item \code{make_sparse = TRUE}: If \code{TRUE}, zeros out small alpha values.
\item \code{convex_combination = TRUE}: If \code{TRUE}, constrain alpha to sum
to 1.
\item \code{init_0 = FALSE}: If \code{TRUE}, alpha is initialized to all 0's,
useful for TMLE. Otherwise, it is initialized to equal weights summing
to 1, useful for Super Learner.
\item \code{outer.iter = 400}: Maximum number of major (outer) iterations.
\item \code{inner.iter = 800}: Maximum number of minor (inner) iterations.
\item \code{delta = 1e-7}:Relative step size in forward difference evaluation.
\item \code{tol = 1e-8}: Relative tolerance on feasibility and optimality.
\item \code{trace = FALSE}: The value of the objective function and the
parameters are printed at every major iteration.
\item \code{...}: Additional arguments defined in \code{\link{Lrnr_base}},
such as \code{params} (like \code{formula}) and \code{name}.
}
}

\examples{
# define ML task
data(cpp_imputed)
covs <- c("apgar1", "apgar5", "parity", "gagebrth", "mage", "meducyrs")
task <- sl3_Task$new(cpp_imputed, covariates = covs, outcome = "haz")

# build relatively fast learner library (not recommended for real analysis)
lasso_lrnr <- Lrnr_glmnet$new()
glm_lrnr <- Lrnr_glm$new()
ranger_lrnr <- Lrnr_ranger$new()
lrnrs <- c(lasso_lrnr, glm_lrnr, ranger_lrnr)
names(lrnrs) <- c("lasso", "glm", "ranger")
lrnr_stack <- make_learner(Stack, lrnrs)

# instantiate SL with GA metalearner
solnp_meta <- Lrnr_solnp$new()
sl <- Lrnr_sl$new(lrnr_stack, solnp_meta)
sl_fit <- sl$train(task)
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
