% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_lightgbm.R
\docType{class}
\name{Lrnr_lightgbm}
\alias{Lrnr_lightgbm}
\title{LightGBM: Light Gradient Boosting Machine}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This learner provides fitting procedures for \code{lightgbm} models, using
the \pkg{lightgbm} package, via \code{\link[lightgbm]{lgb.train}}. These
gradient boosted decision tree models feature faster training speed and
efficiency, lower memory usage than competing frameworks (e.g., from the
\pkg{xgboost} package), better prediction accuracy, and improved handling of
large-scale data. For details on the fitting procedure and its tuning
parameters, consult the documentation of the \pkg{lightgbm} package. The
LightGBM framework was introduced in \insertCite{lightgbm;textual}{sl3}).
}
\section{Parameters}{

\itemize{
\item \code{num_threads = 1L}: Number of threads for hyperthreading.
\item \code{...}: Other arguments passed to \code{\link[lightgbm]{lgb.train}}.
See its documentation for further details.
}
}

\examples{
\dontrun{
# currently disabled since LightGBM crashes R on Windows
# more info at https://github.com/tlverse/sl3/issues/344
data(cpp_imputed)
# create task for prediction
cpp_task <- sl3_Task$new(
  data = cpp_imputed,
  covariates = c("bmi", "parity", "mage", "sexn"),
  outcome = "haz"
)

# initialization, training, and prediction with the defaults
lgb_lrnr <- Lrnr_lightgbm$new()
lgb_fit <- lgb_lrnr$train(cpp_task)
lgb_preds <- lgb_fit$predict()

# get feature importance from fitted model
lgb_varimp <- lgb_fit$importance()
}
}
\references{
\insertAllCited{}
}
\seealso{
\link{Lrnr_gbm} for standard gradient boosting models (via the \pkg{gbm}
package) and \link{Lrnr_xgboost} for the extreme gradient boosted tree models
from the Xgboost framework (via the \pkg{xgboost} package).

Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
