% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_haldensify.R
\docType{class}
\name{Lrnr_haldensify}
\alias{Lrnr_haldensify}
\title{Conditional Density Estimation with the Highly Adaptive LASSO}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
Conditional Density Estimation with the Highly Adaptive LASSO
}
\section{Parameters}{

\itemize{
\item \code{grid_type = "equal_range"}: A \code{character} indicating the
strategy to be used in creating bins along the observed support of
\code{A}. For bins of equal range, use \code{"equal_range"}; consult
the documentation of \code{\link[ggplot2]{cut_interval}} for further
information. To ensure each bin has the same number of observations,
use \code{"equal_mass"}; consult the documentation of
\code{\link[ggplot2]{cut_number}} for details. The default is
\code{"equal_range"} since this has been found to provide better
performance in simulation experiments; however, both types may be
specified (i.e., \code{c("equal_range", "equal_mass")}) together, in
which case cross-validation will be used to select the optimal binning
strategy.
\item \code{n_bins = c(3, 5)}: This \code{numeric} value indicates the number
of bins into which the support of \code{A} is to be divided. As with
\code{grid_type}, multiple values may be specified, in which
cross-validation will be used to select the optimal number of bins.
\item \code{lambda_seq = exp(seq(-1, -13, length = 1000L))}: A \code{numeric}
sequence of regularization parameter values of Lasso regression, which
are passed to \code{\link[hal9001]{fit_hal}} via its argument
\code{lambda}, itself passed to \code{\link[glmnet]{glmnet}}.
\item \code{trim_dens = 1/sqrt(n)}: A \code{numeric} giving the minimum
allowed value of the resultant density predictions. Any predicted
density values below this tolerance threshold are set to the indicated
minimum. The default is to use the inverse of the square root of the
sample size of the prediction set, i.e., 1/sqrt(n); another notable
choice is 1/sqrt(n)/log(n). If there are observations in the
prediction set with values of \code{new_A} outside of the support of
the training set, their predictions are similarly truncated.
\item \code{...}: Other arguments to be passed directly to
\code{\link[haldensify]{haldensify}}. See its documentation for
details.
}
}

\examples{
library(dplyr)
data(cpp_imputed)
covars <- c("parity", "sexn")
outcome <- "haz"

# create task
task <- cpp_imputed \%>\%
  slice(seq(1, nrow(.), by = 3)) \%>\%
  filter(agedays == 1) \%>\%
  sl3_Task$new(
    covariates = covars,
    outcome = outcome
  )

# instantiate the learner
hal_dens <- Lrnr_haldensify$new(
  grid_type = "equal_range",
  n_bins = c(3, 5),
  lambda_seq = exp(seq(-1, -13, length = 100))
)

# fit and predict densities
hal_dens_fit <- hal_dens$train(task)
hal_dens_preds <- hal_dens_fit$predict()
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
