% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_h2o_glm.R
\docType{class}
\name{define_h2o_X}
\alias{define_h2o_X}
\alias{Lrnr_h2o_glm}
\title{h2o Model Definition}
\format{
\code{\link{R6Class}} object.
}
\usage{
define_h2o_X(task, outcome_type = NULL)
}
\arguments{
\item{task}{An object of type \code{Lrnr_base} as defined in this package.}

\item{outcome_type}{An object of type \code{Variable_Tyoe} for use in
formatting the outcome}
}
\value{
Learner object with methods for training and prediction. See
\code{\link{Lrnr_base}} for documentation on learners.
}
\description{
Definition of \code{h2o} type models. This function is for internal use only.
This function uploads input data into an \code{h2o.Frame}, allowing the data
to be subset to the \code{task$X} \code{data.table} by a smaller set of
covariates if spec'ed in params.

This learner provides faster fitting procedures for generalized linear models
by using the \code{h2o} package and the \code{\link[h2o]{h2o.glm}} method.
The h2o Platform fits GLMs in a computationally efficient manner. For details
on the procedure, consult the documentation of the \code{h2o} package.
}
\section{Parameters}{

\describe{
\item{\code{intercept=TRUE}}{If \code{TRUE}, and intercept term is
included.}
\item{\code{standardize=TRUE}}{Standardize covariates to have mean = 0 and
SD = 1.}
\item{\code{lambda=0}}{Lasso Parameter.}
\item{\code{max_iterations=100}}{Maximum number of iterations.}
\item{\code{ignore_const_columns=FALSE}}{If \code{TRUE}, drop constant
covariate columns}
\item{\code{missing_values_handling="Skip"}}{How to handle missing values.}
\item{\code{...}}{Other arguments passed to \code{\link[h2o]{h2o.glm}}.}
}
}

\section{Common Parameters}{


Individual learners have their own sets of parameters. Below is a list of shared parameters, implemented by \code{Lrnr_base}, and shared
by all learners.

\describe{
\item{\code{covariates}}{A character vector of covariates. The learner will use this to subset the covariates for any specified task}
\item{\code{outcome_type}}{A \code{\link{variable_type}} object used to control the outcome_type used by the learner. Overrides the task outcome_type if specified}
\item{\code{...}}{All other parameters should be handled by the invidual learner classes. See the documentation for the learner class you're instantiating}
}
}

\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
