% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_glmnet.R
\docType{class}
\name{Lrnr_glmnet}
\alias{Lrnr_glmnet}
\title{GLMs with Elastic Net Regularization}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This learner provides fitting procedures for elastic net models, including
both lasso (L1) and ridge (L2) penalized regression, using the \pkg{glmnet}
package. The function \code{\link[glmnet]{cv.glmnet}} is used to select an
appropriate value of the regularization parameter lambda. For details on
these regularized regression models and \pkg{glmnet}, consider consulting
\insertCite{glmnet;textual}{sl3}).
}
\section{Parameters}{

\itemize{
\item \code{lambda = NULL}: An optional vector of lambda values to compare.
\item \code{type.measure = "deviance"}: The loss to use when selecting
lambda. Options documented in \code{\link[glmnet]{cv.glmnet}}.
\item \code{nfolds = 10}: Number of folds to use for internal cross-validation.
\item \code{alpha = 1}: The elastic net parameter: \code{alpha = 0} is Ridge
(L2-penalized) regression, while \code{alpha = 1} specifies Lasso
(L1-penalized) regression. Values in the closed unit interval specify a
weighted combination of the two penalties. For further details, consult
the documentation of \code{\link[glmnet]{glmnet}}.
\item \code{nlambda = 100}: The number of lambda values to fit. Comparing
fewer values will speed up computation, but may hurt the statistical
performance. For further details, consult the documentation of
\code{\link[glmnet]{cv.glmnet}}.
\item \code{use_min = TRUE}: If \code{TRUE}, the smallest value of the lambda
regularization parameter is used for prediction (i.e.,
\code{lambda = cv_fit$lambda.min}); otherwise, a larger value is used
(i.e., \code{lambda = cv_fit$lambda.1se}). The distinction between the
two variants is clarified in the documentation of
\code{\link[glmnet]{cv.glmnet}}.
\item \code{stratify_cv = FALSE}: Stratify internal cross-validation folds, so
that a binary outcome's prevalence for training is roughly the same in
the training and validation sets of the internal cross-validation
folds? This argument can only be used when the outcome type for
training is binomial; and either the \code{id} node in the task is not
specified, or \code{\link[glmnet]{cv.glmnet}}'s \code{foldid} argument
is not specified upon initializing the learner.
\item \code{...}: Other parameters passed to \code{\link[glmnet]{cv.glmnet}}
and \code{\link[glmnet]{glmnet}}.
}
}

\examples{
data(mtcars)
mtcars_task <- sl3_Task$new(
  data = mtcars,
  covariates = c(
    "cyl", "disp", "hp", "drat", "wt", "qsec", "vs", "am",
    "gear", "carb"
  ),
  outcome = "mpg"
)
# simple prediction with lasso penalty
lasso_lrnr <- Lrnr_glmnet$new()
lasso_fit <- lasso_lrnr$train(mtcars_task)
lasso_preds <- lasso_fit$predict()

# simple prediction with ridge penalty
ridge_lrnr <- Lrnr_glmnet$new(alpha = 0)
ridge_fit <- ridge_lrnr$train(mtcars_task)
ridge_preds <- ridge_fit$predict()
}
\references{
\insertAllCited{}
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
