% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_gam.R
\docType{class}
\name{Lrnr_gam}
\alias{Lrnr_gam}
\title{GAM: Generalized Additive Models}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This learner provides fitting procedures for generalized additive models,
using the routines from \pkg{mgcv} through a call to the function
\code{\link[mgcv]{gam}}. The \pkg{mgcv} package and the use of GAMs are
described thoroughly (with examples) in \insertCite{mgcv;textual}{sl3},
while \insertCite{hastie-gams;textual}{sl3} also provided an earlier quite
thorough look at GAMs.
}
\section{Parameters}{

\itemize{
\item \code{formula}: An optional argument specifying the formula of GAM.
Input type can be formula or string, or a list of them. If not
specified, continuous covariates will be smoothened with the smooth
terms represented using "penalized thin plate regression splines". For
a more detailed description, please consult the documentation for
\code{\link[mgcv]{gam}}.
\item \code{family}: An optional argument specifying the family of the GAM.
See \code{\link[stats]{family}} and \code{\link[mgcv]{family.mgcv}}
for a list of available family functions. If left unspecified, it will
be inferred depending on the detected type of the outcome. For now,
GAM supports binomial and gaussian outcome types, if \code{formula} is
unspecified. For a more detailed description of this argument, please
consult the documentation of \code{\link[mgcv]{gam}}.
\item \code{method}: An optional argument specifying the method for smoothing
parameter selection. The default is global cross-validation (GCV). For
more detaileds on this argument, consult the documentation of
\code{\link[mgcv]{gam}}.
\item \code{...}: Other parameters passed to \code{\link[mgcv]{gam}}. See its
documentation for details.
}
}

\examples{
data(cpp_imputed)
# create task for prediction
cpp_task <- sl3_Task$new(
  data = cpp_imputed,
  covariates = c("bmi", "parity", "mage", "sexn"),
  outcome = "haz"
)
# initialization, training, and prediction with the defaults
gam_lrnr <- Lrnr_gam$new()
gam_fit <- gam_lrnr$train(cpp_task)
gam_preds <- gam_fit$predict()
}
\references{
\insertAllCited{}
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
