% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_bound.R
\docType{class}
\name{Lrnr_bound}
\alias{Lrnr_bound}
\title{Bound Predictions}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This learner bounds predictions. Intended for use as part of
\code{\link{Pipeline}}.
}
\section{Parameters}{

\itemize{
\item \code{bound}: Either a vector of length two, with lower and upper
bounds, or a vector of length 1 with a lower bound, and the upper will
be set symmetrically as 1 - the lower bound. Both bounds must be
provided when the variable type of the task's outcome is continuous.
}
}

\examples{
data(cpp_imputed)
covs <- c("apgar1", "apgar5", "parity", "gagebrth", "mage", "meducyrs")
task <- sl3_Task$new(cpp_imputed, covariates = covs, outcome = "haz")

hal_lrnr <- Lrnr_hal9001$new(
  max_degree = 1, num_knots = c(20, 10), smoothness_orders = 0
)
lasso_lrnr <- Lrnr_glmnet$new()
glm_lrnr <- Lrnr_glm$new()
ranger_lrnr <- Lrnr_ranger$new()
lrnr_stack <- make_learner(Stack, lasso_lrnr, glm_lrnr, ranger_lrnr)
lrnr_bound <- Lrnr_bound$new(c(-2, 2))
stack_bounded_preds <- Pipeline$new(lrnr_stack, lrnr_bound)
metalrnr_discrete_MSE <- Lrnr_cv_selector$new(loss_squared_error)
discrete_sl <- Lrnr_sl$new(
  learners = stack_bounded_preds, metalearner = metalrnr_discrete_MSE
)
discrete_sl_fit <- discrete_sl$train(task)
preds <- discrete_sl_fit$predict()
range(preds)
}
\keyword{data}
