% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer.R
\docType{package}
\name{simmer-package}
\alias{simmer-package}
\title{\pkg{simmer}: Discrete-Event Simulation for \R}
\description{
A process-oriented and trajectory-based Discrete-Event Simulation (DES)
package for \R. Designed to be a generic framework like \pkg{SimPy} or
\pkg{SimJulia}, it leverages the power of \pkg{Rcpp} to boost the performance
and turning DES in \R feasible. As a noteworthy characteristic, \pkg{simmer}
exploits the concept of trajectory: a common path in the simulation model for
entities of the same type. It is pretty flexible and simple to use, and
leverages the chaining/piping workflow introduced by the \pkg{magrittr} package.
}
\examples{
\dontrun{
# introduction to simmer
vignette("simmer-01-introduction")

# JSS paper available as vignette
vignette("simmer-02-jss")

# more vignettes
vignette(package = "simmer")
}

}
\references{
Ucar I., Smeets B., Azcorra A. (2019).
"\pkg{simmer}: Discrete-Event Simulation for \R."
\emph{Journal of Statistical Software}, \strong{90}(2), 1-30.
\doi{10.18637/jss.v090.i02}.

Ucar I., Hernández J.A., Serrano P., Azcorra A. (2018).
"Design and Analysis of 5G Scenarios with \pkg{simmer}: An \R Package for
Fast DES Prototyping."
\emph{IEEE Communications Magazine}, \strong{56}(11), 145-151.
\doi{10.1109/MCOM.2018.1700960}.
}
\seealso{
\pkg{simmer}'s homepage \url{https://r-simmer.org} and
GitHub repository \url{https://github.com/r-simmer/simmer}.
}
\author{
Iñaki Ucar and Bart Smeets
}
