% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{activate}
\alias{activate}
\alias{deactivate}
\title{Activate/Deactivate Sources}
\usage{
activate(.trj, sources, ..., tag)

deactivate(.trj, sources, ..., tag)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{sources}{the name(s) of the source(s) or a function returning the name(s).}

\item{...}{unused.}

\item{tag}{activity tag name to perform named rollbacks (see
\code{\link{rollback}}) or just to better identify your activities.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for activating or deactivating the generation of arrivals by name.
Sources must be defined in the simulation environment (see
\code{\link{add_generator}}, \code{\link{add_dataframe}}).
}
\examples{
traj <- trajectory() \%>\%
  deactivate("dummy") \%>\%
  timeout(1) \%>\%
  activate("dummy")

simmer() \%>\%
  add_generator("dummy", traj, function() 1) \%>\%
  run(10) \%>\%
  get_mon_arrivals()

}
\seealso{
\code{\link{set_trajectory}}, \code{\link{set_source}}
}
