% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effcop.R
\name{effcop}
\alias{effcop}
\alias{effcopFit}
\alias{reffcop}
\title{Fit Vine copula models to matrices of effectiveness scores}
\usage{
effcopFit(x, eff, ...)

reffcop(n, .effcop)
}
\arguments{
\item{x}{a matrix or data frame of effectiveness scores to estimate dependence.}

\item{eff}{a list of effectiveness distributions to use for the margins.}

\item{...}{other parameters for \code{\link[rvinecopulib]{vinecop}}, such as \code{family_set},
\code{selcrit}, \code{trunc_lvl} and \code{cores}.}

\item{n}{number of observations to simulate.}

\item{.effcop}{the \code{effcop} object representing the copula model (see \code{effcopFit}).}
}
\value{
\code{effcopFit}: an object of class \code{effcop}, with the following components:

  \tabular{rl}{
    \code{data} \tab the matrix of effectiveness scores used to fit the copula. \cr
    \code{pobs} \tab the matrix of pseudo-observations computed from \code{data}. This is stored
      because pseudo-observations are calculated breaking ties randomly
      (see \code{\link[rvinecopulib]{pseudo_obs}}). \cr
    \code{margins} \tab the list of marginal effectiveness distributions. \cr
    \code{cop} \tab the underlying copulas fitted with \code{\link[rvinecopulib]{vinecop}}.
  }
These components may be altered to gain specific simulation capacity, such as
  \link[=effTransform]{systems with the same expected value}.

\code{reffcop}: a matrix of random scores.
}
\description{
Fitting of and simulation from a copula model.
}
\examples{
\donttest{
## Automatically build a gaussian copula to many systems
d <- web2010p20[,1:20] # sample P@20 data from 20 systems
effs <- effDiscFitAndSelect(d, support("p20")) # fit and select margins
cop <- effcopFit(d, effs, family_set = "gaussian") # fit copula
y <- reffcop(1000, cop) # simulate new 1000 topics

# compare observed vs. expected mean
E <- sapply(effs, function(e) e$mean)
E.hat <- colMeans(y)
plot(E, E.hat)
abline(0:1)

# compare observed vs. expected variance
Var <- sapply(effs, function(e) e$var)
Var.hat <- apply(y, 2, var)
plot(Var, Var.hat)
abline(0:1)
}
}
\seealso{
\code{\link{effCont}} and \code{\link{effDisc}} for available distributions for the
  margins. See package \code{\link[rvinecopulib]{rvinecopulib}} for details on fitting
  the copulas.
}
