% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effCont-helper.R
\name{effCont-helper}
\alias{effCont-helper}
\alias{cap}
\alias{effContMean}
\alias{effContVar}
\alias{effContTrunc}
\title{Helper functions for continuous effectiveness distributions}
\usage{
cap(x, xmin = 1e-06, xmax = 1 - xmin)

effContMean(qfun, abs.tol = 1e-06, subdivisions = 500)

effContVar(qfun, mu, abs.tol = 1e-06, subdivisions = 500)

effContTrunc(dfun, pfun, qfun, ...)
}
\arguments{
\item{x}{a sample of effectiveness scores.}

\item{xmin}{lowest value to cap scores.}

\item{xmax}{highest value to cap scores.}

\item{qfun}{a quantile function.}

\item{abs.tol}{absolute accuracy requested, passed to \code{\link{integrate}}.}

\item{subdivisions}{the maximum number of subintervals, passed to \code{\link{integrate}}.}

\item{mu}{the expected value of the distribution (see \code{effContMean}).}

\item{dfun}{a density function.}

\item{pfun}{a distribution function.}

\item{...}{additional arguments passed to other functions, if any.}
}
\value{
\code{cap}: the original vector, but censored.

  \code{effContMean}: the estimate of the expected value.

  \code{effContVar}: the estimate of the variance.

  \code{effContTrunc}: a list with components:
  \tabular{ll}{
    \code{td} \tab the truncated density function. \cr
    \code{tp} \tab the truncated distribution function. \cr
    \code{tq} \tab the truncated quantile function.
  }
}
\description{
These are functions to help in the creation and use of continuous effectiveness distributions.
}
\details{
\code{cap} caps (censor) a variable from below and above.

\code{effContMean} computes the expected value of a distribution by numerical integration of the
given quantile function.

\code{effContVar} computes the variance of a distribution by numerical integration of the given
quantile function.

\code{effContTrun} computes the density, distribution and quantile functions of the distribution
resulting from truncating a given distribution between 0 and 1.
}
\examples{
cap(c(0, .5, 1))

effContMean(function(p) qnorm(p, mean = 4))
effContMean(function(p) qbeta(p, 1, 2))

effContVar(function(p) qnorm(p, mean = 2, sd = 4), 2)
effContVar(function(p) qbeta(p, 1, 2), 1/3)

tr <- effContTrunc(dnorm, pnorm, qnorm, mean = .8, sd = .3)
x01 <- seq(0, 1, .01)
plot(x01, tr$d(x01), type = "l")
plot(x01, tr$p(x01), type = "l")
plot(x01, tr$q(x01), type = "l")
}
\seealso{
\code{\link[=eff.cont-class]{eff.cont}}.
}
