\name{sgolayfilt}
\alias{sgolayfilt}
\alias{filter.sgolayFilter}
\title{ Apply a Savitzky-Golay smoothing filter }
\description{
Smooth data with a Savitzky-Golay smoothing filter.
}
\usage{
sgolayfilt(x, p = 3, n = p + 3 - p\%\%2, m = 0, ts = 1)

\method{filter}{sgolayFilter}(filt, x, \ldots)
}
\arguments{
  \item{x}{ signal to be filtered. }
  \item{p}{ filter order. }
  \item{n}{ filter length (must be odd). }
  \item{m}{ return the m-th derivative of the filter coefficients.}
  \item{ts}{ time scaling factor. }
  \item{filt}{ filter characteristics (normally generated by \code{sgolay}). }
  \item{\ldots}{ additional arguments (ignored). }
}
\details{
These filters are particularly good at preserving lineshape while
removing high frequency squiggles. 
}
\value{
  The filtered signal, of \code{length(x)}.
}
\references{
  Octave Forge \url{https://octave.sourceforge.io/}
}
\author{ Original Octave version by Paul Kienzle
  \email{pkienzle@users.sf.net}. Modified by Pascal Dupuis. Conversion to R by Tom Short. }

\seealso{ \code{\link{sgolay}}, \code{\link{filter}}}
\examples{
# Compare a 5 sample averager, an order-5 butterworth lowpass
# filter (cutoff 1/3) and sgolayfilt(x, 3, 5), the best cubic
# estimated from 5 points.
bf <- butter(5,1/3)
x <- c(rep(0,15), rep(10, 10), rep(0, 15))
sg <- sgolayfilt(x)
plot(sg, type="l")
lines(filtfilt(rep(1, 5)/5,1,x), col = "red") # averaging filter
lines(filtfilt(bf,x), col = "blue")           # butterworth
points(x, pch = "x")                          # original data
}
\keyword{ math }
