% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{textOutput}
\alias{textOutput}
\alias{verbatimTextOutput}
\title{Create a text output element}
\usage{
textOutput(outputId, container = if (inline) span else div, inline = FALSE)

verbatimTextOutput(outputId, placeholder = FALSE)
}
\arguments{
\item{outputId}{output variable to read the value from}

\item{container}{a function to generate an HTML element to contain the text}

\item{inline}{use an inline (\code{span()}) or block container (\code{div()})
for the output}

\item{placeholder}{if the output is empty or \code{NULL}, should an empty
rectangle be displayed to serve as a placeholder? (does not affect
behavior when the output is nonempty)}
}
\value{
An output element for use in UI.
}
\description{
Render a reactive output variable as text within an application page.
\code{textOutput()} is usually paired with \code{\link[=renderText]{renderText()}} and puts regular text
in \verb{<div>} or \verb{<span>}; \code{verbatimTextOutput()} is usually paired with
\code{\link[=renderPrint]{renderPrint()}} and provides fixed-width text in a \verb{<pre>}.
}
\details{
In both functions, text is HTML-escaped prior to rendering.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = basicPage(
      textInput("txt", "Enter the text to display below:"),
      textOutput("text"),
      verbatimTextOutput("verb")
    ),
    server = function(input, output) {
      output$text <- renderText({ input$txt })
      output$verb <- renderText({ input$txt })
    }
  )
}
}
