
<!-- badges: start -->
[![CRAN](https://www.r-pkg.org/badges/version/sentometrics)](https://cran.r-project.org/package=sentometrics)
[![codecov](https://codecov.io/github/SentometricsResearch/sentometrics/branch/master/graphs/badge.svg)](https://codecov.io/github/SentometricsResearch/sentometrics)
[![Downloads](https://cranlogs.r-pkg.org/badges/last-day/sentometrics?color=ff69b4)](https://www.r-pkg.org/pkg/sentometrics)
[![Downloads](https://cranlogs.r-pkg.org/badges/sentometrics?color=ff69b4)](https://www.r-pkg.org/pkg/sentometrics)
[![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/sentometrics?color=ff69b4)](https://www.r-pkg.org/pkg/sentometrics)
<!-- badges: end -->

# sentometrics <a href='https://www.sentometrics.org'><img src='man/figures/logo.png' style="padding-left:2px" align="right" width="160"/></a>

> The **`sentometrics`** package offers an **integrated framework for textual sentiment time series aggregation and prediction**. It accounts for the intrinsic challenge that textual sentiment can be computed in many different ways, as well as the large number of possibilities to pool sentiment into a time series index. The package integrates the fast _quantification_ of sentiment from texts, the _aggregation_ into different sentiment time series, and the _prediction_ based on these measures. All in one coherent workflow! 

Explore this package website to learn about what you can do with **`sentometrics`** and how so.

### Reference

Please cite **`sentometrics`** in publications. See the **Citation** section on the right.

### Acknowledgements

This software package originates from a
[Google Summer of Code 2017](https://github.com/rstats-gsoc/gsoc2017/wiki/Sentometrics:-An-integrated-framework-for-text-based-multivariate-time-series-modeling-and-forecasting) project, was further developed 
during a follow-up [Google Summer of Code 2019](https://github.com/rstats-gsoc/gsoc2019/wiki/sentometrics) project, and benefited generally from financial support by [Innoviris](https://innoviris.brussels), [IVADO](https://www.ivado.ca), [swissuniversities](https://www.swissuniversities.ch), and the [Swiss National Science Foundation](http://www.snf.ch) (grants #179281 and #191730).

<!-- <img height="71" src="man/figures/gsoc.png" alt="GSoC" style="margin-right:8px"/>
<img height="79" src="man/figures/innoviris.png" alt="Innoviris" style="display:inline-block;margin-right:8px"/>
<img height="77" src="man/figures/ivado.png" alt="IVADO" style="display:inline-block;margin-right:8px"/>
<img height="79" src="man/figures/swissuniversities.png" alt="swissuniversities" style="display:inline-block;margin-right:8px"/>
<img height="88" src="man/figures/snsf.png" alt="SNSF" style="display:inline-block;margin-right:8px"/> -->

### Contact

Reach out to [Samuel Borms](mailto:borms_sam@hotmail.com) if you have questions, suggestions or want to become a contributor. See the **News > Development** section to find out what you can help us with.

