% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_influence_stat.R
\name{print.influence_stat}
\alias{print.influence_stat}
\title{Print an 'influence_stat' Class Object}
\usage{
\method{print}{influence_stat}(
  x,
  digits = 3,
  what = c("parameters", "fit_measures", "mahalanobis"),
  first = 10,
  sort_parameters_by = c("gcd", "est"),
  sort_fit_measures_by = NULL,
  sort_mahalanobis = TRUE,
  sort_fit_measures_decreasing = TRUE,
  sort_fit_measures_on_absolute = TRUE,
  sort_mahalanobis_decreasing = TRUE,
  ...
)
}
\arguments{
\item{x}{An 'influence_stat'-class object.}

\item{digits}{The number of digits after the decimal.
Default is 3.}

\item{what}{A character vector of the
results #' to be printed, can be
one or more of the following:
\code{"parameters"}, \code{"fit_measures"},
and \code{"mahalanobis"}. Default
is \code{c("parameters", "fit_measures", "mahalanobis")}.}

\item{first}{Numeric. If not \code{NULL}, it prints
only the first \emph{k} cases, \emph{k} equal to \code{first}.
Default is 10.}

\item{sort_parameters_by}{String.
If it is \code{"est"}, the cases are sorted individually
on each columns. If it is \code{"gcd"},
the default,
then cases are sorted by generalized Cook's distance
or approximate generalized Cook's distance, depending on
which column is available.
If \code{NULL}, cases are not sorted.}

\item{sort_fit_measures_by}{String. Default is \code{NULL} and
the output of case influence on fit measures is not
sorted. If set to a column
names of case influence on fit measures , cases will
sorted by these columns.
The sorting is done on the absolute values
if \code{sort_fit_measures_on_absolute} is \code{TRUE}, and in decreasing
order if \code{decreasing} is \code{TRUE}. If \code{decrease}
is \code{FALSE}, the order is increasing. If \code{sort_fit_measures_on_absolute}
is \code{FALSE}, the sorting is done on the raw values.}

\item{sort_mahalanobis}{Logical. If \code{TRUE}, the default, the cases
in the output of Mahalanobis distance
will be sorted based on Mahalanobis distance.
The order is determined by \code{sort_mahalanobis_decreasing}.}

\item{sort_fit_measures_decreasing}{Logical. Whether cases, if sorted
on fit measures,
are on decreasing order in the output of
case influence on fit measures. Default is \code{TRUE}.}

\item{sort_fit_measures_on_absolute}{Logical. Whether
cases, if sorted on fit measures,
are sorted on absolute values of fit measures. Default is \code{TRUE}.
See \code{sort_fit_measures_by}.}

\item{sort_mahalanobis_decreasing}{Logical. Whether cases, if sorted
on Mahalanobis distance,
is on decreasing order. Default is \code{TRUE}.}

\item{...}{Optional arguments. Passed to
other print methods, such as \code{\link[=print.est_change]{print.est_change()}},
\code{\link[=print.fit_measures_change]{print.fit_measures_change()}}, and \code{\link[=print.md_semfindr]{print.md_semfindr()}}.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the content of an 'influence_stat'-class object.
}
\details{
This method will print
the output of \code{\link[=influence_stat]{influence_stat()}} in a user-friendly
way. Users can select the set(s) of output,
case influence on parameter estimates,
case influence on fit measures, and
Mahalanobis distance, to be printed.
The corresponding print methods of
\code{est_change}-class objects,
\code{fit_measures_change}-class objects,
and \code{md_semfindr}-class objects will be called.
}
\examples{
library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# --- Leave-One-Out Approach

# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Get all default influence stats
out <- influence_stat(fit_rerun)
out
print(out, first = 4)
print(out, what = c("parameters", "fit_measures"))

# --- Approximate Approach

out_approx <- influence_stat(fit)
out_approx
print(out, first = 8)
print(out, what = c("parameters", "fit_measures"),
      sort_parameters_by = "est")

}
\seealso{
\code{\link[=influence_stat]{influence_stat()}}, \code{\link[=print.est_change]{print.est_change()}},
\code{\link[=print.fit_measures_change]{print.fit_measures_change()}}, \code{\link[=print.md_semfindr]{print.md_semfindr()}}
}
