% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_okabeito.R
\name{okabeito_colors}
\alias{okabeito_colors}
\alias{oi_colors}
\title{Extract Okabe-Ito colors as hex codes}
\usage{
okabeito_colors(..., original_names = FALSE, black_first = FALSE, amber = TRUE)

oi_colors(..., original_names = FALSE, black_first = FALSE, amber = TRUE)
}
\arguments{
\item{...}{Character names of colors.}

\item{original_names}{Logical. Should the colors be named using the original
names used by Okabe and Ito (2008), such as "vermillion" (\code{TRUE}), or
simplified names, such as "red" (\code{FALSE}, default)?
Only used if no colors are specified (to see all available colors).}

\item{black_first}{Logical. Should black be first (\code{TRUE}) or last (\code{FALSE}, default)
in the color palette? Only used if no colors are specified (to see all
available colors).}

\item{amber}{If amber color should replace yellow in the palette.}
}
\value{
A character vector with color-codes.
}
\description{
Can be used to get the hex code of specific colors from the Okabe-Ito palette.
Use \code{okabeito_colors()} to see all available colors.
}
\examples{
okabeito_colors()

okabeito_colors(c("red", "light blue", "orange"))

okabeito_colors(original_names = TRUE)

okabeito_colors(black_first = TRUE)
}
