# nocov start
make_enum_list <- function(type = "family", file = "src/sdmTMB.cpp") {
  x <- readLines(file)
  valid_start <- grep(paste0("valid_", type), x)
  close_braces <- grep("}", x)
  close_brace <- close_braces[close_braces > valid_start][1]
  out <- x[seq(valid_start, close_brace)]
  out <- sub("enum ", ".", out)
  out <- sub(";", "", out)
  out <- sub("\\{", "<- c\\(", out)
  out <- sub("\\}", "\\)", out)
  out[seq(2, length(out))] <- gsub(paste0("_", type),
    "", out[seq(2, length(out))])
  out <- lapply(out, function(x) paste(x, collapse = "\n"))
  paste(out, collapse = "\n")
}

make_enum <- function(output = "R/enum.R") {
  out <- list()
  out[[1]] <- "# Generated by sdmTMB:::make_enum(): do not edit by hand\n"
  out[[2]] <- make_enum_list("family")
  out[[3]] <- make_enum_list("link")
  out <- lapply(out, function(x) paste(x, collapse = "\n"))
  out <- paste(out, collapse = "\n")
  writeLines(out, con = output)
}
# nocov end
