% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmeInfo-imports.R
\name{CI_g}
\alias{CI_g}
\title{Calculates a confidence interval for a standardized mean difference
  effect size}
\arguments{
\item{g}{an estimated effect size object of class \code{g_REML}, class
\code{g_HPS}, or class \code{g_mlm}.}

\item{cover}{confidence level}

\item{bound}{numerical tolerance for non-centrality parameter in
\code{\link[stats]{qt}}.}

\item{symmetric}{If \code{TRUE} (the default), use a symmetric confidence
interval. If \code{FALSE}, use a non-central t approximation to obtain an
asymmetric confidence interval.}
}
\value{
A vector of upper and lower confidence bounds.
}
\description{
Calculates a confidence interval given a \code{g_REML}, a
  \code{g_HPS}, or a \code{g_mlm} object using either a central t
  distribution (for a symmetric interval) or a non-central t distribution
  (for an asymmetric interval).
}
\examples{
data(Laski)
Laski_RML <- lme(fixed = outcome ~ treatment,
                 random = ~ 1 | case,
                 correlation = corAR1(0, ~ time | case),
                 data = Laski)
Laski_g_REML <- suppressWarnings(
  g_REML(Laski_RML, p_const = c(0,1), 
         r_const = c(1,0,1), returnModel = FALSE)
)
CI_g(Laski_g_REML, symmetric = TRUE)
CI_g(Laski_g_REML, symmetric = FALSE)

Laski_HPS <- with(Laski, effect_size_MB(outcome, treatment, case, time))
CI_g(Laski_HPS, symmetric = FALSE)

Laski_g_mlm <- g_mlm(mod = Laski_RML, p_const = c(0,1), r_const = c(1,0,1))
CI_g(Laski_g_mlm, symmetric = FALSE)

}
