## Do not edit this file manually.
## It has been automatically generated from *.org sources.

## TODO: need proper tests here
test_that("functions in sarima.R work ok", {
    ## define a seasonal ARIMA model
    m1 <- new("SarimaModel", iorder = 1, siorder = 1, ma = -0.3, sma = -0.1, nseasons = 12)
    expect_output(summary(m1))
    expect_output(show(m1))
    iOrder(m1)
    siOrder(m1)
    anyUnitRoots(m1)
    nSeasons(m1)
    nSeasons(as(m1, "SarimaFilter"))

    fi1 <- as(m1, "SarimaFilter")
    nSeasons(fi1) <- 4
    expect_equal(nSeasons(fi1), 4)

    m1a <- new("SarimaModel", iorder = 1, siorder = 1, ma = -0.3)
    m1b <- new("SarimaModel", iorder = 1, ma = -0.3)
    filterPoly(m1a)
    anyUnitRoots(m1a)
    expect_output(show(m1a))
    modelPolyCoef(m1a, "ArmaFilter")
    modelPolyCoef(m1a, "ArmaFilter", lag_0 = FALSE)
    expect_error(modelCoef(m1a, "ArModel"), "has non-trivial moving average part")
    expect_error(modelCoef(m1a, "MaModel"), "has non-trivial autoregressive part")
    model0 <- modelCoef(m1, "ArmaModel")
    model1 <- as(model0, "list")

    modelCoef(m1, "SarimaFilter")
    modelCoef(m1, "ArmaFilter")
    modelCoef(new("SarimaModel", iorder = 1, siorder = 1, nseasons = 12), "ArFilter")
    modelCoef(new("SarimaModel", ma = -0.3, sma = -0.1, nseasons = 12), "MaFilter")

    modelCoef(new("SarimaModel", iorder = 1, siorder = 1, nseasons = 12), "ArModel")
    modelCoef(new("SarimaModel", ma = -0.3, sma = -0.1, nseasons = 12), "MaModel")
    
    modelCoef(m1, "ArmaModel")
    expect_error(modelCoef(m1, "ArFilter"))
    expect_error(modelCoef(m1, "MaFilter"))

    modelOrder(m1b, "ArmaFilter")
    expect_error(modelOrder(m1b, "ArFilter"), "Non-zero moving average order")
    expect_error(modelOrder(m1b, "MaFilter"), "Non-zero autoregressive order")

    expect_error(modelOrder(m1b, "ArmaModel"), "iorder == 0 is not TRUE")
    expect_error(modelOrder(m1b, "ArModel"), "iorder == 0 is not TRUE")
    expect_error(modelOrder(m1b, "MaModel"), "iorder == 0 is not TRUE")

    as.list(m1b)
    as(m1b, "list")
    expect_error(as(m1b, "ArmaModel"), "This SARIMA model is not stationary")


    expect_error(xarmaFilter(model1, x = AirPassengers, whiten = TRUE, from = 4),
                 ".from. must be greater than max\\(p,q\\)")
    xarmaFilter(model1, x = AirPassengers, whiten = TRUE, xintercept = 3)
    xarmaFilter(model1, x = AirPassengers, whiten = TRUE, xcenter = 10)
    xarmaFilter(c(model1, center = 10), x = AirPassengers, whiten = TRUE)

    .beforeInitMain(list(before = numeric(5), init = numeric(5), main = numeric(5), dummy = 1))
    .beforeInitMain(numeric(5))

    ap.1 <- xarmaFilter(model1, x = AirPassengers, whiten = TRUE)
    ap.2 <- xarmaFilter(model1, x = AirPassengers, eps = ap.1, whiten = FALSE)
    ap <- AirPassengers
    ap[-(1:13)] <- 0 # check that the filter doesn't use x, except for initial values.
    ap.2a <- xarmaFilter(model1, x = ap, eps = ap.1, whiten = FALSE)
    xarmaFilter(model1, eps = ap.1, whiten = FALSE)

    ap.2a - ap.2 ## indeed = 0
    ##ap.3 <- xarmaFilter(model1, x = list(init = AirPassengers[1:13]), eps = ap.1, whiten = TRUE)
    
    ## now set some non-zero initial values for eps
    eps1 <- numeric(length(AirPassengers))
    eps1[1:13] <- rnorm(13)
    ap.A <- xarmaFilter(model1, x = AirPassengers, eps = eps1, whiten = TRUE)
    ap.Ainv <- xarmaFilter(model1, x = ap, eps = ap.A, whiten = FALSE)
    AirPassengers - ap.Ainv # = 0
    
    ## compare with sarima.f (an old function)
    ## compute predictions starting at from = 14
    pred1 <- sarima.f(past = AirPassengers[1:13], n = 131, ar = model1$ar, ma = model1$ma)
    
    sarima.f(past = AirPassengers, n = 131, ar = model1$ar, ma = model1$ma) # 'past' longer than needed

    pred2 <- xarmaFilter(model1, x = ap, whiten = FALSE)
    pred2 <- pred2[-(1:13)]
    all(pred1 == pred2) ##TRUE
    expect_true(all(pred1 == pred2))

    set.seed(1234)
    moA <- sim_sarima(n=144, model = list(ar=c(1.2,-0.8), ma=0.4, sar=0.3, sma=0.7,
                               iorder=1, siorder=1, nseasons=12))
    set.seed(1234)
    moB <- sim_sarima(n=144, model = list(ar=c(1.2,-0.8), ma=0.4, sar=0.3, sma=0.7,
                               iorder=1, siorder=1, nseasons=12, sigma2 = 1))
    expect_equal(moA, moB)

    fun.forecast(ar = 0.5, n = 10)

    ## from prepareSimSarima.Rd
    mo1 <- list(ar = 0.9, iorder = 1, siorder = 1, nseasons = 4, sigma2 = 2)
    fs1 <- prepareSimSarima(mo1, x = list(before = rep(0,6)),  n = 100)
    expect_output(print(fs1))
    tmp1 <- fs1()

    ## more
    moX <- list(ar = c(-0.5, 0.25), ma = +0.3, sigma2 = 2)
    expect_true(environment(prepareSimSarima(moX, n = 100))$flag.stat.init.values)
    (prepareSimSarima(moX, n = 100))()

    prepareSimSarima(mo1)
    prepareSimSarima(mo1, n = 10)
    prepareSimSarima(c(mo1, list(intercept = 3)), n = 10)
    prepareSimSarima(mo1, xintercept = 3, n = 10)
    prepareSimSarima(mo1, xintercept = 3, n = 10)
    prepareSimSarima(mo1, xintercept = 1:10, n = 10)
    prepareSimSarima(mo1, eps = list(before = rep(0,6)), n = 10)


    expect_error(prepareSimSarima(mo1, x = list(before = rep(0,6)),  
                                     eps = list(before = rep(0,4)), n = 10),
    "Lengths of xbefore and innovbefore must be equal if both are present")

    expect_error(prepareSimSarima(mo1, x = list(init = rep(0,6)),  
                                     eps = list(init = rep(0,4)), n = 10),
          "Lengths of xinit and innovinit must be equal if both are present")

    prepareSimSarima(mo1, x  = list(init = rep(0,6)),  n = 100)
    prepareSimSarima(mo1, eps = list(init = rep(0,6)),  n = 100)

})
