% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{decrypt_string}
\alias{decrypt_string}
\title{Decrypt a string or a raw vector}
\usage{
decrypt_string(string, key = "pass", pkey = NULL, url = FALSE)
}
\arguments{
\item{string}{A string(character vector of length 1) without embedded NULL to
be encrypted. or a raw vector.}

\item{key}{For symmetric decryption, 'pkey' should be NULL (default) and
'key' can be either a string (Default is 'pass') or a raw object. For
asymmetric decryption, both 'key' (private key of the decrypter) and 'pkey'
(public key of the encrypter) should be raw objects.}

\item{pkey}{See 'key'}

\item{url}{(flag, default: FALSE) Whether the encoded string was generated
url friendly.}
}
\value{
decrypted string
}
\description{
\code{encrypt_string} encrypts a string as a string or a raw vector and
  \code{decrypt_string} decrypts the encrypted string or a raw vector (encrypted using
  \code{encrypt_string})
}
\examples{
# symmetric case:
temp <- encrypt_string("hello, how are you", key = "secret")
all(
  is.character(temp)
  , decrypt_string(temp, "secret") == "hello, how are you"
  , class(try(decrypt_string(temp, "nopass"), silent = TRUE)) == "try-error"
  )

# string encoded as raw
res <- encrypt_string("tatvamasi", ascii = FALSE)
res

isTRUE(identical(decrypt_string(res), "tatvamasi"))

# asymmetric case:
alice <- keypair()
bob   <- keypair()
temp  <- encrypt_string("hello asymmetric", alice$private_key, bob$public_key)
temp2 <- decrypt_string(temp, bob$private_key, alice$public_key)
identical("hello asymmetric", temp2)

}
