% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkingGramSimilarityMatrix.R
\name{checking.gram.similarityMatrix}
\alias{checking.gram.similarityMatrix}
\title{Gram similarity matrix checker}
\usage{
checking.gram.similarityMatrix(W, flagDiagZero = FALSE, verbose = FALSE)
}
\arguments{
\item{W}{Gram Similarity Matrix or not.}

\item{flagDiagZero}{if True, Put zero on the similarity matrix W.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
a Gram similarity matrix
}
\description{
Function to check if a similarity matrix is Gram or not
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
W <- compute.similarity.ZP(scale(sameTwoDisks))
W <- checking.gram.similarityMatrix(W)

### Example 2: Speed and Stopping Distances of Cars
W <- compute.similarity.ZP(scale(cars))
W <- checking.gram.similarityMatrix(W)
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
