# Guidelines for contributing to this project

Any constructive contributions &ndash; bug reports, pull requests (code or documentation), suggestions for improvements, and more &ndash; are welcome.

## Discussions

Discussion is welcome by creating a new issue [in this repository](https://github.com/pboesu/rucrdtw/issues).

## Conduct

Everyone is asked to read and respect the [code of conduct](https://github.com/pboesu/rucrdtw/blob/master/CODE_OF_CONDUCT.md) before participating directly in this project.

## How to contribute text, edits, and other materials

### Using GitHub (doesn't require knowing Git)

1. Fork the repository
1. Click the link for one of the files
1. Click the **Edit** button, then make some edits
1. Add a commit summary and (optionally) an extended description
1. Click the **Commit Changes** button
1. Create a pull request by clicking the **Pull Request** button at the top of the main page of your copy of the repository

### Using Git

1. Fork the repository, for example to https://github.com/YOUR-GITHUB-ACCOUNT/rucrdtw
1. Clone your fork locally
1. Create a branch to hold your changes (`git checkout -b my-changes`)
1. Commit the changes you've made (`git commit -am "Some descriptive text around what you've added"`)
1. Push your branch to GitHub (`git push origin my-changes`)
1. Create a pull request, for example at https://github.com/YOUR-GITHUB-ACCOUNT/rucrdtw/pull/new/master

## License

[![License: Apache 2.0](https://img.shields.io/cran/l/rucrdtw)](https://github.com/pboesu/rucrdtw/blob/master/LICENSE)

## Acknowledgments

This file was adapted from [Combine-Org](https://raw.githubusercontent.com/combine-org/Community-guidelines/master/CONTRIBUTING.md) the [code4lib anti-harassment policy repository](https://github.com/code4lib/code-of-conduct) on GitHub.  Their content is licensed under CC0.  Subsequent modifications were made by COMBINE members as indicated in the GitHub commit history.
