% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{client_as}
\alias{client_as}
\title{Set default client for the current session}
\usage{
client_as(client = NULL)
}
\arguments{
\item{client}{One of the following options:
\itemize{
\item \code{NULL}, the default, will look for rtweet's "default" authentication
which uses your personal default Twitter client. If it's not found, it will
call \code{\link[=client_setup_default]{client_setup_default()}} to set it up.
\item A string giving the name of a saved auth file made by \code{\link[=client_save]{client_save()}}.
\item A client object created by \code{\link[=rtweet_client]{rtweet_client()}}.
}}
}
\value{
Invisibly returns the previous authentication mechanism.
}
\description{
\code{client_as()} sets up the default client used by rtweet API calls with PKCE. See \code{\link[=rtweet_user]{rtweet_user()}} to learn more about the three
available authentication options.
}
\examples{
\dontrun{
# Use app auth for the remainder of this session:
my_app <- rtweet_app()
auth_as(my_app)

# Switch back to the default user based auth
client_as()
client_list()
}
}
\seealso{
Other client: 
\code{\link{client_get}()},
\code{\link{client_has_default}()},
\code{\link{client_save}()}
}
\concept{client}
