% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_statuses.R
\name{lists_statuses}
\alias{lists_statuses}
\title{Get a timeline of tweets authored by members of a specified list.}
\usage{
lists_statuses(
  list_id = NULL,
  slug = NULL,
  owner_user = NULL,
  since_id = NULL,
  max_id = NULL,
  n = 200,
  include_rts = TRUE,
  parse = TRUE,
  retryonratelimit = NULL,
  verbose = TRUE,
  token = NULL
)
}
\arguments{
\item{list_id}{required The numerical id of the list.}

\item{slug}{required You can identify a list by its slug instead of
its numerical id. If you decide to do so, note that you'll also have
to specify the list owner using the owner_id or owner_screen_name
parameters.}

\item{owner_user}{optional The screen name or user ID of the user
who owns the list being requested by a slug.}

\item{since_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{newer} than \code{since_id}.}

\item{max_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{older} than \code{max_id}.}

\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{include_rts}{optional When set to either true, t or 1,
the list timeline will contain native retweets (if they exist) in
addition to the standard stream of tweets. The output format of
retweeted tweets is identical to the representation you see in
home_timeline.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely solely on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}
}
\value{
data
}
\description{
Get a timeline of tweets authored by members of a specified list.
}
\examples{
if (auth_has_default()) {
  (rladies <- lists_statuses(list_id = "839186302968848384"))
  (rladies <- lists_statuses(slug = "rladies1", owner_user = "RLadiesGlobal"))
}
}
\seealso{
Other lists: 
\code{\link{lists_members}()},
\code{\link{lists_subscribers}()},
\code{\link{lists_subscriptions}()},
\code{\link{lists_users}()}

Other tweets: 
\code{\link{get_favorites}()},
\code{\link{get_mentions}()},
\code{\link{get_timeline}()},
\code{\link{lookup_tweets}()},
\code{\link{search_tweets}()}
}
\concept{lists}
\concept{tweets}
